/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertieUtil {
    private static final Logger LOGGER = Logger.getLogger(PropertieUtil.class);
    private static final String AUTHOR_WHY = "author: why";

    private PropertieUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFile(String filename) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(filename);
            properties.load(inputStream);
        }
        return properties;
    }

    public static Properties readPropertiesFile(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePropertiesFile(String filename, Properties properties) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(filename);
            properties.store(outputStream, AUTHOR_WHY);
        }
    }

    public static void writePropertiesFile(OutputStream outputStream, Properties properties) {
        try {
            properties.store(outputStream, AUTHOR_WHY);
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFileFromXML(String filename) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(filename);
            properties.loadFromXML(inputStream);
        }
        return properties;
    }

    public static Properties readPropertiesFileFromXML(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.loadFromXML(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePropertiesFileToXML(String filename, Properties properties) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(filename);
            properties.storeToXML(outputStream, AUTHOR_WHY);
        }
    }

    public static void writePropertiesFileToXML(OutputStream outputStream, Properties properties) {
        try {
            properties.storeToXML(outputStream, AUTHOR_WHY);
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

