/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class StringCommonUtil {
    public static final String ISO88591 = "ISO-8859-1";
    public static final String GB2312 = "GB2312";
    public static final String GBK = "GBK";
    public static final String UTF8 = "UTF-8";
    private static final Map<String, String> ceMap = new HashMap<String, String>();

    private StringCommonUtil() {
    }

    public static final String charsetConversion(String str, String oldCharset, String newCharset) throws UnsupportedEncodingException {
        return new String(str.getBytes(oldCharset), newCharset);
    }

    public static final String changeToUtf8(String str) throws UnsupportedEncodingException {
        String charset = StringCommonUtil.checkCharset(str);
        return StringCommonUtil.charsetConversion(str, charset, UTF8);
    }

    public static final String checkCharset(String str) throws UnsupportedEncodingException {
        if (str.equals(new String(str.getBytes(ISO88591), ISO88591))) {
            return ISO88591;
        }
        if (str.equals(new String(str.getBytes(GB2312), GB2312))) {
            return GB2312;
        }
        if (str.equals(new String(str.getBytes(GBK), GBK))) {
            return GBK;
        }
        return UTF8;
    }

    public static final String escapeCharacterEntities(String str) {
        String strNew = str;
        for (String key : ceMap.keySet()) {
            strNew = strNew.replace(key, ceMap.get(key));
        }
        return strNew;
    }

    public static final boolean checkSpecialCharacter(String str) {
        int n = -1;
        for (String key : ceMap.keySet()) {
            int m = str.indexOf(key);
            if (m <= -1) continue;
            n = m;
        }
        return n <= -1;
    }

    static {
        ceMap.put("'", "&quot;");
        ceMap.put("&", "&amp;");
        ceMap.put("<", "&lt;");
        ceMap.put(">", "&gt;");
    }
}

