/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util.xml;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlElementUtil {
    private static Logger LOGGER = Logger.getLogger(XmlElementUtil.class);

    public NodeList getNodeList(Element parent) {
        return parent.getChildNodes();
    }

    public Element[] getElements(Element parent) {
        ArrayList<Node> resList = new ArrayList<Node>();
        NodeList nl = this.getNodeList(parent);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (nd.getNodeType() != 1) continue;
            resList.add(nd);
        }
        Element[] res = new Element[resList.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Element)resList.get(i);
        }
        LOGGER.debug((Object)(parent.getNodeName() + "'s childrens num:" + res.length));
        return res;
    }

    public Element[] getElementsByName(Element parent, String name) {
        ArrayList<Node> resList = new ArrayList<Node>();
        NodeList nl = this.getNodeList(parent);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals(name)) continue;
            resList.add(nd);
        }
        Element[] res = new Element[resList.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Element)resList.get(i);
        }
        LOGGER.debug((Object)(parent.getNodeName() + "'s children of " + name + "'s num:" + res.length));
        return res;
    }

    public String getElementName(Element element) {
        return element.getNodeName();
    }

    public String getElementValue(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 3) continue;
            LOGGER.debug((Object)(element.getNodeName() + " has a Text Node."));
            return element.getFirstChild().getNodeValue();
        }
        LOGGER.error((Object)(element.getNodeName() + " hasn't a Text Node."));
        return null;
    }

    public String getElementAttr(Element element, String attr) {
        return element.getAttribute(attr);
    }

    public void setElementValue(Element element, String val) {
        Text node = element.getOwnerDocument().createTextNode(val);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (nd.getNodeType() != 3) continue;
            nd.setNodeValue(val);
            LOGGER.debug((Object)("modify " + element.getNodeName() + "'s node value succe."));
            return;
        }
        LOGGER.debug((Object)("new " + element.getNodeName() + "'s node value succe."));
        element.appendChild(node);
    }

    public void setElementAttr(Element element, String attr, String attrVal) {
        element.setAttribute(attr, attrVal);
    }

    public void addElement(Element parent, Element child) {
        parent.appendChild(child);
    }

    public void addElement(Element parent, String tagName) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElement(tagName);
        parent.appendChild(child);
    }

    public void addElement(Element parent, String tagName, String text) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElement(tagName);
        this.setElementValue(child, text);
        parent.appendChild(child);
    }

    public void removeElement(Element parent, String tagName) {
        LOGGER.debug((Object)("remove " + parent.getNodeName() + "'s children by tagName " + tagName + " begin..."));
        NodeList nl = parent.getElementsByTagName(tagName);
        ArrayList<Node> ndList = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            ndList.add(nl.item(i));
        }
        for (Node node : ndList) {
            parent.removeChild(node);
        }
        nl = parent.getElementsByTagName(tagName);
        LOGGER.debug((Object)("remove " + parent.getNodeName() + "'s children by tagName " + tagName + " end."));
    }
}

