/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static Logger LOGGER = Logger.getLogger(XmlUtil.class);
    private static final String UTF8 = "UTF-8";
    private Document document;

    public void Transform(String xmlFileName, String xslFileName, String htmlFileName) {
        try {
            TransformerFactory tFac = TransformerFactory.newInstance();
            StreamSource xslSource = new StreamSource(xslFileName);
            Transformer t = tFac.newTransformer(xslSource);
            File xmlFile = new File(xmlFileName);
            File htmlFile = new File(htmlFileName);
            StreamSource source = new StreamSource(xmlFile);
            StreamResult result = new StreamResult(htmlFile);
            LOGGER.debug((Object)result.toString());
            t.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Document parserXml(String fileName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.parse(fileName);
            LOGGER.debug((Object)"-----------------------------------\u89e3\u6790\u5b8c\u6bd5----------------------------------------");
            return this.document;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.document;
    }

    public void createXml(String fileName) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", UTF8);
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(new FileOutputStream(fileName));
            transformer.transform(source, result);
            LOGGER.debug((Object)"--------------------------------\u66f4\u65b0 XML\u6587\u4ef6\u6210\u529f-------------------------------------");
        }
        catch (Exception exception) {
            LOGGER.error((Object)("\u66f4\u65b0" + fileName + "\u51fa\u9519\uff1a"), (Throwable)exception);
        }
    }

    public synchronized void createXml(String fileName, Document document) {
        LOGGER.debug((Object)("============\u8fdb\u5165\u751f\u6210xml\u65b9\u6cd5\uff1a" + new Date().toLocaleString() + "================="));
        try {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
                LOGGER.debug((Object)"==============\u5220\u9664xml\u6587\u4ef6==============");
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", UTF8);
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(fileName));
            transformer.transform(source, result);
            LOGGER.debug((Object)"--------------------------------\u66f4\u65b0 XML\u6587\u4ef6\u6210\u529f-------------------------------------");
        }
        catch (Exception exception) {
            LOGGER.error((Object)("\u66f4\u65b0" + fileName + "\u51fa\u9519\uff1a"), (Throwable)exception);
        }
        LOGGER.debug((Object)("============\u9000\u51fa\u751f\u6210xml\u65b9\u6cd5\uff1a" + new Date().toLocaleString() + "================="));
    }

    public String document2Str(Document document) {
        String xmlStr = null;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", UTF8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(document), new StreamResult(bos));
            xmlStr = bos.toString();
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error((Object)"TransformerConfiguration\u9519\u8bef", (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.error((Object)"Transformer\u9519\u8bef", (Throwable)e);
        }
        return xmlStr;
    }

    public Document str2Document(String xmlStr) {
        Document doc = null;
        StringReader sr = new StringReader(xmlStr);
        InputSource is = new InputSource(sr);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"ParserConfiguration\u9519\u8bef", (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"SAX\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IO\u9519\u8bef", (Throwable)e);
        }
        return doc;
    }
}

