/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.common.util.ApplicationContextHelper;
import com.qianjiang.common.util.CacheKeyConstant;
import com.qianjiang.util.MyLogger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.util.CollectionUtils;

public class RedisMap {
    private static final MyLogger DEBUG = new MyLogger(RedisMap.class);
    @Resource
    private static RedisTemplate<String, Serializable> redisTemplate = (RedisTemplate)ApplicationContextHelper.getBean("redisTemplate");
    private static boolean isNeedRedis = false;
    private static boolean isNeedRedisNew = true;

    public static void deleteAll() {
        if (!isNeedRedis) {
            return;
        }
        List<String> keys = RedisMap.getAllCacheKeys();
        DEBUG.debug("Begin to delete keys :" + keys);
        if (!CollectionUtils.isEmpty(keys)) {
            try {
                redisTemplate.delete(new ArrayList<String>(keys));
            }
            catch (Exception e) {
                DEBUG.error("DeleteAll Fail..." + keys);
            }
        }
    }

    private static List<String> getAllCacheKeys() {
        Field[] fields;
        ArrayList<String> keys = new ArrayList<String>();
        Class<CacheKeyConstant> class1 = CacheKeyConstant.class;
        for (Field field : fields = class1.getDeclaredFields()) {
            keys.add(field.getName());
        }
        return keys;
    }

    public static void delete(String key) {
        if (!isNeedRedis) {
            return;
        }
        try {
            redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            DEBUG.error("Delete cache fail and key : " + key);
        }
    }

    public static boolean put(final String key, final Serializable value) {
        if (!isNeedRedis) {
            return true;
        }
        try {
            return (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.set(redisTemplate.getStringSerializer().serialize((Object)key), new JdkSerializationRedisSerializer().serialize((Object)value));
                    return true;
                }
            });
        }
        catch (Exception e) {
            DEBUG.error("Put value to redis fail...", e);
            return false;
        }
    }

    public static Object get(final String key) {
        if (!isNeedRedis) {
            return null;
        }
        try {
            return redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    return new JdkSerializationRedisSerializer().deserialize(connection.get(redisTemplate.getStringSerializer().serialize((Object)key)));
                }
            });
        }
        catch (Exception e) {
            DEBUG.error("Get value from  redis fail...", e);
            return null;
        }
    }

    public static boolean expire(String key, int time) {
        if (!isNeedRedisNew) {
            return true;
        }
        try {
            redisTemplate.expire((Object)key, (long)time, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            DEBUG.error("expire cache fail and key : " + key);
            return false;
        }
    }

    public static boolean put(final String key, final Serializable value, int time) {
        if (!isNeedRedisNew) {
            return true;
        }
        try {
            return (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.set(redisTemplate.getStringSerializer().serialize((Object)key), new JdkSerializationRedisSerializer().serialize((Object)value));
                    return true;
                }
            }) != false && RedisMap.expire(key, time);
        }
        catch (Exception e) {
            DEBUG.error("Put value and time to redis fail...", e);
            return false;
        }
    }

    public static Object getNew(final String key) {
        if (!isNeedRedisNew) {
            return null;
        }
        try {
            return redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    return new JdkSerializationRedisSerializer().deserialize(connection.get(redisTemplate.getStringSerializer().serialize((Object)key)));
                }
            });
        }
        catch (Exception e) {
            DEBUG.error("Get value from  redis fail...", e);
            return null;
        }
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(RedisMap.class.getClassLoader().getResourceAsStream("config/redis.properties"));
            String value = (String)properties.get("redis.start");
            if ("yes".equals(value)) {
                isNeedRedis = true;
            }
            DEBUG.debug("Load redis success and redis start flag :" + isNeedRedis);
        }
        catch (Exception e) {
            DEBUG.error("Load redis.properties fail", e);
        }
    }
}

