/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.dao.InformationTypeMapper;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.information.vo.InformationTypeVo;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="InformationTypeService")
public class InformationTypeServiceImpl
implements InformationTypeService {
    private InformationTypeMapper informationTypeMapper;

    public InformationTypeMapper getInformationTypeMapper() {
        return this.informationTypeMapper;
    }

    @Resource(name="InformationTypeMapper")
    public void setInformationTypeMapper(InformationTypeMapper informationTypeMapper) {
        this.informationTypeMapper = informationTypeMapper;
    }

    @Override
    public void delInformation(Long infoTypeId, Long loginUserId) {
        Set<Long> ids = this.getAllInformationTypeIdByParentid(infoTypeId);
        ids.add(infoTypeId);
        for (Long id : ids) {
            InformationType infoType = this.selectByPrimaryKey(id);
            infoType.setDelflag("1");
            infoType.setUpdateUserId(loginUserId);
            infoType.setUpdateDate(new Date());
            this.informationTypeMapper.updateByPrimaryKeySelective(infoType);
        }
    }

    private Set<Long> getAllInformationTypeIdByParentid(Long infoTypeId) {
        HashSet<Long> ids = new HashSet<Long>();
        List<InformationTypeVo> list = this.informationTypeMapper.selectByParentId(infoTypeId);
        for (InformationTypeVo informationTypeVo : list) {
            this.getAllIds(informationTypeVo, ids);
        }
        return ids;
    }

    private void getAllIds(InformationTypeVo informationTypeVo, Set<Long> ids) {
        ids.add(informationTypeVo.getInfoTypeId());
        List<InformationTypeVo> childs = informationTypeVo.getChilds();
        if (!CollectionUtils.isEmpty(childs)) {
            for (InformationTypeVo informationTypeVo1 : childs) {
                this.getAllIds(informationTypeVo1, ids);
            }
        } else {
            return;
        }
    }

    @Override
    public void delInformationPro(Long infoTypeId) {
        this.informationTypeMapper.deleteByPrimaryKeyPro(infoTypeId);
    }

    @Override
    public void batchDelInformation(Long[] ids, Long loginUserId) {
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                this.delInformation(ids[i], loginUserId);
            }
        }
    }

    @Override
    public void saveInformation(InformationType record) {
        if (record.getParentId() == 0L) {
            record.setGrade(1);
        } else {
            record.setGrade(this.informationTypeMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
        }
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        this.informationTypeMapper.insertSelective(record);
    }

    @Override
    public void updateInformation(InformationType record) {
        if (record.getParentId() == 0L) {
            record.setGrade(1);
        } else {
            record.setGrade(this.informationTypeMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
        }
        record.setUpdateDate(new Date());
        this.informationTypeMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public InformationType selectByPrimaryKey(Long infoTypeId) {
        return this.informationTypeMapper.selectByPrimaryKey(infoTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBean(PageBean pb, String searchText) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("searchText", searchText);
            pb.setRows(this.informationTypeMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.informationTypeMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<InformationTypeVo> selectAll() {
        return this.informationTypeMapper.selectAll();
    }

    @Override
    public List<InformationTypeVo> selectInfoTypeByAttrForAddInfo() {
        return this.informationTypeMapper.selectInfoTypeByAttrForAddInfo();
    }

    @Override
    public List<InformationTypeVo> selectInfoTypeByAttrForTemp() {
        return this.informationTypeMapper.selectInfoTypeByAttrForTemp();
    }

    @Override
    public boolean checkDelWithInfoTypeId(Long infoTypeId) {
        return this.informationTypeMapper.selectCountByParentId(infoTypeId) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getInfoTypeList(PageBean pb, String searchText) {
        ArrayList<Object> infoTypeVoList = new ArrayList<Object>();
        List<Object> parentList = this.queryByPageBean(pb, searchText).getList();
        List<InformationTypeVo> allInfoTypeList = this.informationTypeMapper.selectAll();
        InformationTypeVo infoType = null;
        try {
            for (int i = 0; i < parentList.size(); ++i) {
                infoType = (InformationTypeVo)parentList.get(i);
                infoType.setChilds(this.calcInfoTypeVo(infoType.getInfoTypeId(), allInfoTypeList));
                infoTypeVoList.add(infoType);
            }
            ArrayList<Object> arrayList = infoTypeVoList;
            return arrayList;
        }
        finally {
            infoTypeVoList = null;
            parentList = null;
            allInfoTypeList = null;
            infoType = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InformationTypeVo> calcInfoTypeVo(Long parentId, List<InformationTypeVo> allInfoTypeVoList) {
        ArrayList<InformationTypeVo> infoTypeVoList = new ArrayList<InformationTypeVo>();
        List<InformationTypeVo> allSonCate = null;
        InformationTypeVo infoType = null;
        try {
            for (int i = 0; i < allInfoTypeVoList.size(); ++i) {
                if (!parentId.equals(allInfoTypeVoList.get(i).getParentId())) continue;
                infoType = allInfoTypeVoList.get(i);
                allSonCate = this.calcInfoTypeVo(infoType.getInfoTypeId(), allInfoTypeVoList);
                infoType.setChilds(allSonCate);
                infoTypeVoList.add(infoType);
            }
            ArrayList<InformationTypeVo> arrayList = infoTypeVoList;
            return arrayList;
        }
        finally {
            infoTypeVoList = null;
            allSonCate = null;
            infoType = null;
        }
    }

    @Override
    public boolean checkAddInfoTypeByName(String name) {
        return this.informationTypeMapper.selectInfoTypeCountByName(name) <= 0;
    }

    @Override
    public boolean checkAddInfoTypeByName(String name, Long infoTypeId) {
        InformationType infoType = this.informationTypeMapper.selectByPrimaryKey(infoTypeId);
        if (null != infoType) {
            if (infoType.getName().equals(name)) {
                return true;
            }
            return this.informationTypeMapper.selectInfoTypeCountByName(name) <= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBeanList(PageBean pb, String searchText) {
        int i;
        ArrayList<Object> typeList = new ArrayList<Object>();
        List<InformationType> infolist = this.informationTypeMapper.selectAllType(searchText);
        ArrayList<InformationType> parentList = new ArrayList<InformationType>();
        if (infolist != null) {
            for (i = 0; i < infolist.size(); ++i) {
                if (infolist.get(i).getParentId() != 0L) continue;
                parentList.add(infolist.get(i));
            }
        }
        try {
            for (i = 0; i < parentList.size(); ++i) {
                InformationType type = (InformationType)parentList.get(i);
                type.setTypeList(this.calcType(type.getInfoTypeId(), infolist));
                typeList.add(type);
            }
            pb.setList(typeList);
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            typeList = null;
            parentList = null;
            infolist = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InformationType> calcType(Long parentId, List<InformationType> typeList) {
        ArrayList<InformationType> cateVoList = new ArrayList<InformationType>();
        List<InformationType> allSonCate = null;
        try {
            for (int i = 0; i < typeList.size(); ++i) {
                if (!parentId.equals(typeList.get(i).getParentId())) continue;
                InformationType cate = typeList.get(i);
                allSonCate = this.calcType(cate.getInfoTypeId(), typeList);
                cate.setTypeList(allSonCate);
                cateVoList.add(cate);
            }
            ArrayList<InformationType> arrayList = cateVoList;
            return arrayList;
        }
        finally {
            cateVoList = null;
            allSonCate = null;
        }
    }
}

