/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.service.impl;

import com.qianjiang.manager.bean.Authority;
import com.qianjiang.manager.bean.AuthorityPage;
import com.qianjiang.manager.bean.ManagerAuthority;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.mapper.AuthorityMapper;
import com.qianjiang.manager.mapper.AuthorityPageMapper;
import com.qianjiang.manager.mapper.ManagerAuthorityMapper;
import com.qianjiang.manager.mapper.PageMapper;
import com.qianjiang.manager.service.AuthorityServiceInterface;
import com.qianjiang.util.PageBean;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Service;

@Service(value="authorityService")
public class AuthorityService
implements AuthorityServiceInterface {
    private static final String CREATEID = "createId";
    private static final String AUTHORITYID = "authorityId";
    private static final String PAGEID = "pageId";
    private AuthorityMapper authorityMapper;
    private ManagerAuthorityMapper managerAuthorityMapper;
    private AuthorityPageMapper authorityPageMapper;
    private PageMapper pageMapper;

    @Override
    public List<Authority> queryAuthoerityList(Long createId) {
        return this.authorityMapper.selectAllAuthority(createId);
    }

    public AuthorityMapper getAuthorityMapper() {
        return this.authorityMapper;
    }

    @Resource(name="authorityMapper")
    public void setAuthorityMapper(AuthorityMapper authorityMapper) {
        this.authorityMapper = authorityMapper;
    }

    public PageMapper getPageMapper() {
        return this.pageMapper;
    }

    @Resource(name="PageMapperImpl")
    public void setPageMapper(PageMapper pageMapper) {
        this.pageMapper = pageMapper;
    }

    public AuthorityPageMapper getAuthorityPageMapper() {
        return this.authorityPageMapper;
    }

    @Resource(name="authorityPageMapper")
    public void setAuthorityPageMapper(AuthorityPageMapper authorityPageMapper) {
        this.authorityPageMapper = authorityPageMapper;
    }

    @Override
    public ManagerAuthority queryAuthorByManagerId(Long mid) {
        return this.managerAuthorityMapper.selectByManagerId(mid);
    }

    public ManagerAuthorityMapper getManagerAuthorityMapper() {
        return this.managerAuthorityMapper;
    }

    @Resource(name="managerAuthorityMapper")
    public void setManagerAuthorityMapper(ManagerAuthorityMapper managerAuthorityMapper) {
        this.managerAuthorityMapper = managerAuthorityMapper;
    }

    @Override
    public Authority selectAuthByManagerId(Long id) {
        return this.authorityMapper.selectAuthByManagerId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryAuthoerityList(Authority authority, PageBean pageBean, Long createId) {
        Authority authorityNew = authority;
        HashMap<String, Object> paramMap = null;
        Integer no = 0;
        try {
            if (authorityNew == null) {
                authorityNew = new Authority();
            }
            authorityNew.setCreateId(createId);
            pageBean.setRows(Integer.parseInt(this.authorityMapper.queryAuthoritySize(authorityNew) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (authorityNew != null) {
                authorityNew.setStartRowNum(pageBean.getStartRowNum());
                authorityNew.setEndRowNum(pageBean.getEndRowNum());
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            paramMap.put(CREATEID, createId);
            pageBean.setObjectBean(authorityNew);
            pageBean.setList(authorityNew == null ? this.authorityMapper.selectAuthorityByLimit(paramMap) : this.authorityMapper.selectAuthorityByAuthority(authorityNew));
        }
        finally {
            paramMap = null;
            no = null;
        }
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAuthority(String[] parameterValues) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("parameterValues", parameterValues);
            count = this.authorityMapper.deleteAuthorityByIds(paramMap);
        }
        finally {
            paramMap = null;
        }
        return count;
    }

    @Override
    public int mergeAuthority(String split, Authority authority) {
        int num = this.authorityMapper.updateByPrimaryKeySelective(authority);
        if (split.length() != 0) {
            ArrayList<Map<String, Object>> authorities = new ArrayList<Map<String, Object>>(0);
            ArrayList<Long> pageList = new ArrayList<Long>(0);
            for (String str : split.split(",")) {
                pageList.add(Long.parseLong(str));
            }
            List<Long> pageIds = this.pageMapper.selectByPrimaryKeys(pageList);
            for (Long id : pageIds) {
                char type;
                HashMap<String, Constable> map = new HashMap<String, Constable>();
                char c = type = id != null && id == 0L ? (char)'0' : '1';
                if (id == null) continue;
                map.put(AUTHORITYID, authority.getId());
                map.put(PAGEID, id);
                map.put("type", Character.valueOf(type));
                authorities.add(map);
            }
            this.authorityPageMapper.insertAuthorities(authorities);
        }
        return num;
    }

    @Override
    public int isAuthCanDelete(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return 0;
        }
        for (String id : ids) {
            if (this.authorityMapper.queryManangerAuthCount(id) <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int updateAuthority(String split, Authority authority) {
        int num = this.authorityMapper.updateByPrimaryKey(authority);
        if (split.length() != 0) {
            for (String str : split.split(",")) {
                char type;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Long result = this.pageMapper.selectByPrimaryKey(Long.parseLong(str)).getId();
                char c = type = result != null && result == 0L ? (char)'0' : '1';
                if (result == null) continue;
                map.put(AUTHORITYID, authority.getId());
                map.put(PAGEID, Long.parseLong(str));
                map.put("type", Character.valueOf(type));
                this.authorityPageMapper.insertAAndPage(map);
                map.clear();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAuthority(String split, Authority authority, Long createId) {
        int num = 0;
        Long aid = 0L;
        HashMap<String, Object> paramMap = null;
        if (authority.getId() != null) {
            aid = authority.getId();
        } else {
            paramMap = new HashMap<String, Object>();
            paramMap.put("designation", authority.getDesignation());
            paramMap.put("characterization", authority.getCharacterization());
            paramMap.put("id", authority.getId());
            paramMap.put(CREATEID, createId);
            num = this.authorityMapper.insertByDesignation(paramMap);
            aid = this.authorityMapper.selectLastId();
        }
        try {
            if (split.length() != 0) {
                for (String str : split.split(",")) {
                    char type;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Long result = this.pageMapper.selectByPrimaryKey(Long.parseLong(str)).getId();
                    char c = type = result != null && result == 0L ? (char)'0' : '1';
                    if (result == null) continue;
                    map.put(AUTHORITYID, aid);
                    map.put(PAGEID, Long.parseLong(str));
                    map.put("type", Character.valueOf(type));
                    num += this.authorityPageMapper.insertAAndPage(map);
                    map.clear();
                }
            }
        }
        finally {
            paramMap = null;
            aid = null;
        }
        return num;
    }

    @Override
    public Authority queryAuthorId(Long id) {
        return this.authorityMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<AuthorityPage> queryAuthorityByAId(Long id) {
        return this.authorityMapper.selectAuthorityByAId(id);
    }

    @Override
    public int deleteAuthorityPage(Long id) {
        return this.authorityPageMapper.deleteAuthorityPageById(id);
    }

    @Override
    public Authority querySupperAuthor() {
        return this.authorityMapper.querySupperAuthor();
    }

    @Override
    public Long checkAuthExist(String authName) {
        return this.authorityMapper.checkAuthExist(authName);
    }

    @Override
    public Authority checkManagerExist(String username) {
        return this.authorityMapper.checkManagerExist(username);
    }

    @Override
    public void addAuthorityPageBatch(Long authorityId, List<MenuVo> menuVos) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(AUTHORITYID, authorityId);
        paramMap.put("menuVos", menuVos);
        this.authorityPageMapper.addAuthorityPageBatch(paramMap);
    }

    @Override
    public void deleteAuthByBundleName(String bundleName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bundleName", bundleName);
        this.authorityPageMapper.deleteAuthByParam(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertAuthorities(String split, Authority authority, Long createId) {
        int num = 0;
        Long aid = 0L;
        HashMap<String, Object> paramMap = null;
        if (authority.getId() != null) {
            aid = authority.getId();
        } else {
            paramMap = new HashMap<String, Object>();
            paramMap.put("designation", authority.getDesignation());
            paramMap.put("characterization", authority.getCharacterization());
            paramMap.put("id", authority.getId());
            paramMap.put(CREATEID, createId);
            num = this.authorityMapper.insertByDesignation(paramMap);
            aid = this.authorityMapper.selectLastId();
        }
        try {
            if (split.length() != 0) {
                ArrayList<Map<String, Object>> authorities = new ArrayList<Map<String, Object>>(0);
                ArrayList<Long> pageList = new ArrayList<Long>(0);
                for (String str : split.split(",")) {
                    pageList.add(Long.parseLong(str));
                }
                List<Long> pageIds = this.pageMapper.selectByPrimaryKeys(pageList);
                for (Long id : pageIds) {
                    char type;
                    HashMap<String, Constable> map = new HashMap<String, Constable>();
                    char c = type = id != null && id == 0L ? (char)'0' : '1';
                    if (id == null) continue;
                    map.put(AUTHORITYID, aid);
                    map.put(PAGEID, id);
                    map.put("type", Character.valueOf(type));
                    authorities.add(map);
                }
                this.authorityPageMapper.insertAuthorities(authorities);
            }
        }
        finally {
            paramMap = null;
            aid = null;
        }
        return num;
    }
}

