/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.auth.alipay.util;

import com.qianjiang.system.auth.alipay.util.AlipayCore;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpProtocolHandler;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpRequest;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpResponse;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpResultType;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;

public final class AlipaySubmit {
    public static final MyLogger LOGGER = new MyLogger(AlipaySubmit.class);

    private AlipaySubmit() {
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipayCore.buildMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", "MD5");
        return sPara;
    }

    public static String buildForm(Map<String, String> sParaTemp, String gateway, String strMethod, String strButtonName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuilder sbHtml = new StringBuilder();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"" + gateway + "_input_charset=" + "utf-8" + "\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    private static NameValuePair[] generatNameValuePair(Map<String, String> properties) {
        NameValuePair[] nameValuePair = new NameValuePair[properties.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            nameValuePair[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        return nameValuePair;
    }

    public static String sendPostInfo(Map<String, String> sParaTemp, String gateway) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        HttpProtocolHandler httpProtocolHandler = HttpProtocolHandler.getInstance();
        HttpRequest request = new HttpRequest(HttpResultType.BYTES);
        request.setCharset("utf-8");
        request.setParameters(AlipaySubmit.generatNameValuePair(sPara));
        request.setUrl(gateway + "_input_charset=" + "utf-8");
        HttpResponse response = httpProtocolHandler.execute(request);
        if (response == null) {
            return null;
        }
        String strResult = null;
        try {
            strResult = response.getStringResult();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", e);
            strResult = null;
        }
        return strResult;
    }
}

