/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.weixin.util;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.weixin.util.WeiXinUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.stereotype.Service;

@Service
public class OwerAcessTokenUtil {
    private static AuthService authService;

    public static String getAcessToken(HttpServletRequest request, HttpServletResponse response) {
        Auth auth = authService.findAuthByAuthType("7");
        if (auth != null) {
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + auth.getAuthClientId() + "&secret=" + auth.getAuthClientSecret();
            GetMethod getTokenMethod = new GetMethod(url);
            HttpClient clientToken = new HttpClient();
            getTokenMethod.getParams().setContentCharset("utf-8");
            String res = "";
            String token = "";
            try {
                clientToken.executeMethod((HttpMethod)getTokenMethod);
                res = getTokenMethod.getResponseBodyAsString();
                token = WeiXinUtil.getWxAcessToken(res);
                if (token == null) {
                    throw new NullPointerException();
                }
                return token;
            }
            catch (Exception e) {
                String name = (String)request.getSession().getAttribute("name");
                String ip = IPAddress.getIpAddr(request);
                long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
                OperaLogBean operaLogBean = new OperaLogBean(e, "Sedding accesstoken request failed!");
                operaLogBean.setName(name);
                operaLogBean.setIp(ip);
                operaLogBean.setLoginUserId(loginUserId);
                OperaLogUtil.addOperaException(operaLogBean);
            }
        } else {
            try {
                throw new NullPointerException();
            }
            catch (Exception e) {
                String name = (String)request.getSession().getAttribute("name");
                String ip = IPAddress.getIpAddr(request);
                long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
                OperaLogBean operaLogBean = new OperaLogBean(e, "Getting WEIXIN set failed!");
                operaLogBean.setName(name);
                operaLogBean.setIp(ip);
                operaLogBean.setLoginUserId(loginUserId);
                OperaLogUtil.addOperaException(operaLogBean);
            }
        }
        return null;
    }

    public AuthService getAuthService() {
        return authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        OwerAcessTokenUtil.authService = authService;
    }
}

