/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.service.impl;

import com.qianjiang.manager.bean.Manager;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.mapper.AuthorityPageMapper;
import com.qianjiang.manager.mapper.ManagerAuthorityMapper;
import com.qianjiang.manager.service.ManagerServiceInterface;
import com.qianjiang.manager.service.MenuServiceInterface;
import com.qianjiang.manager.service.PageServiceInterface;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="menuServiceInterface")
public final class MenuService
implements MenuServiceInterface {
    private ManagerAuthorityMapper managerAuthorityMapper;
    private AuthorityPageMapper authorityPageMapper;
    private PageServiceInterface pageServiceInterface;
    private ManagerServiceInterface managerServiceInterface;

    @Override
    public List<MenuVo> getMenuLists(Manager manager) {
        Long num = this.managerAuthorityMapper.selectByManagerId(manager.getId()).getAuthorityId();
        List<MenuVo> menuVoList = this.authorityPageMapper.selectByAuthorityID(num);
        List<MenuVo> parentMenuVos = this.authorityPageMapper.selectAllMenuVos(num);
        this.fillMenuList(parentMenuVos, menuVoList);
        return parentMenuVos;
    }

    public List<MenuVo> getAllMenus(String name) {
        return this.authorityPageMapper.selectAllMenuVo(this.managerAuthorityMapper.selectByManagerId(this.managerServiceInterface.queryManagerByName(name).getId()).getAuthorityId());
    }

    private void fillMenuList(List<MenuVo> parentMenuVos, List<MenuVo> menuVoList) {
        for (int i = 0; i < parentMenuVos.size(); ++i) {
            MenuVo menuVo = parentMenuVos.get(i);
            for (int j = 0; j < menuVoList.size(); ++j) {
                MenuVo mv = menuVoList.get(j);
                if (!(menuVo.getId() + "").equals(mv.getParentId() + "")) continue;
                if (menuVo.getMenuVos() == null) {
                    menuVo.setMenuVos(new ArrayList<MenuVo>());
                }
                menuVo.getMenuVos().add(mv);
            }
            parentMenuVos.set(i, menuVo);
            if (menuVo.getMenuVos() == null) continue;
            this.fillMenuList(menuVo.getMenuVos(), menuVoList);
        }
    }

    @Override
    public List<MenuVo> getAllMenu() {
        return this.pageServiceInterface.queryAllParentMenuVo();
    }

    @Override
    public List<MenuVo> getAllMenuByLogin(Long managerId) {
        return this.pageServiceInterface.queryAllParentMenuVoByLogin(managerId);
    }

    public void bb(List<MenuVo> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (objs.get(i).getMenuVos() == null) continue;
                this.bb(objs.get(i).getMenuVos());
            }
        }
    }

    public ManagerAuthorityMapper getManagerAuthorityMapper() {
        return this.managerAuthorityMapper;
    }

    @Resource(name="managerAuthorityMapper")
    public void setManagerAuthorityMapper(ManagerAuthorityMapper managerAuthorityMapper) {
        this.managerAuthorityMapper = managerAuthorityMapper;
    }

    public AuthorityPageMapper getAuthorityPageMapper() {
        return this.authorityPageMapper;
    }

    @Resource(name="authorityPageMapper")
    public void setAuthorityPageMapper(AuthorityPageMapper authorityPageMapper) {
        this.authorityPageMapper = authorityPageMapper;
    }

    public PageServiceInterface getPageServiceInterface() {
        return this.pageServiceInterface;
    }

    @Resource(name="PageService")
    public void setPageServiceInterface(PageServiceInterface pageServiceInterface) {
        this.pageServiceInterface = pageServiceInterface;
    }

    public ManagerServiceInterface getManagerServiceInterface() {
        return this.managerServiceInterface;
    }

    @Resource(name="managerService")
    public void setManagerServiceInterface(ManagerServiceInterface managerServiceInterface) {
        this.managerServiceInterface = managerServiceInterface;
    }
}

