/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.service.impl;

import com.qianjiang.mobile.bean.MobAdver;
import com.qianjiang.mobile.dao.MobAdverMapper;
import com.qianjiang.mobile.service.MobAdverService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="MobAdverService")
public class MobAdverServiceImpl
implements MobAdverService {
    @Resource(name="MobAdverMapper")
    private MobAdverMapper mobAdverMapper;
    private static final MyLogger LOGGER = new MyLogger(MobAdverServiceImpl.class);

    @Override
    public int batchDelMobAdver(List<Long> ids) {
        return this.mobAdverMapper.batchDelMobAdver(ids);
    }

    @Override
    public int deleteMobAdver(Long mobAdverId) {
        return this.mobAdverMapper.deleteByPrimaryKey(mobAdverId);
    }

    @Override
    public int updateMobAdver(MobAdver mobAdver) {
        mobAdver.setUpdateDate(new Date());
        return this.mobAdverMapper.updateByPrimaryKeySelective(mobAdver);
    }

    @Override
    public int createMobAdver(MobAdver mobAdver) {
        Date date = new Date();
        mobAdver.setCreateDate(date);
        mobAdver.setUpdateDate(date);
        return this.mobAdverMapper.insertSelective(mobAdver);
    }

    @Override
    public MobAdver getMobAdver(Long mobAdverId) {
        return this.mobAdverMapper.selectByPrimaryKey(mobAdverId);
    }

    @Override
    public PageBean selectByStoreyIdAndPb(PageBean pb, Long storeyId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.mobAdverMapper.selectCountByStoreyId(storeyId));
            map.put("storeyId", storeyId);
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.mobAdverMapper.selectByStoreyIdAndPb(map));
        }
        catch (Exception e) {
            LOGGER.error("\u79fb\u52a8\u7248\u5e7f\u544a\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff1a=>", e);
        }
        return pb;
    }

    @Override
    public boolean selectCountByStoreyId(Long storeyId) {
        return this.mobAdverMapper.selectCountByStoreyId(storeyId) <= 0;
    }

    @Override
    public List<MobAdver> selectByStoreyIdForSite(Long storeyId) {
        return this.mobAdverMapper.selectByStoreyIdForSite(storeyId);
    }

    @Override
    public int changeMobAdverUserdStatus(Long mobAdverId) {
        MobAdver mobAdver = this.mobAdverMapper.selectByPrimaryKey(mobAdverId);
        if ("0".equals(mobAdver.getUserStatus())) {
            mobAdver.setUserStatus("1");
        } else {
            mobAdver.setUserStatus("0");
        }
        mobAdver.setUpdateDate(new Date());
        return this.mobAdverMapper.updateByPrimaryKeySelective(mobAdver);
    }
}

