/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.dao.DeliveryPointMapper;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.vo.DistrictVo;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="DeliveryPointService")
public class DeliveryPointServiceImpl
implements DeliveryPointService {
    @Resource(name="DeliveryPointMapper")
    private DeliveryPointMapper deliveryPointMapper;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    private static final Logger LOGGER = Logger.getLogger(DeliveryPointServiceImpl.class);

    @Override
    public int deleteDeliveryPoint(Long deliveryPointId) {
        int n = -1;
        try {
            n = this.deliveryPointMapper.deleteByPrimaryKey(deliveryPointId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u5220\u9664\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        return n;
    }

    @Override
    public int batchDelDeliveryPoint(Long[] deliveryPointIds) {
        int n = -1;
        try {
            n = this.deliveryPointMapper.batchDeleteByPrimaryKey(deliveryPointIds);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6279\u91cf\u5220\u9664\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        return n;
    }

    @Override
    public int saveDeliveryPoint(DeliveryPoint record) {
        int n = -1;
        try {
            Date date = new Date();
            record.setCreateDate(date);
            record.setUpdateDate(date);
            n = this.deliveryPointMapper.insertSelective(record);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6dfb\u52a0\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        return n;
    }

    @Override
    public DeliveryPoint getDeliveryPoint(Long deliveryPointId) {
        return this.deliveryPointMapper.selectByPrimaryKey(deliveryPointId);
    }

    @Override
    public int updateDeliveryPoint(DeliveryPoint record) {
        int n = -1;
        try {
            record.setUpdateDate(new Date());
            n = this.deliveryPointMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u4fee\u6539\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllDeliveryPointByPb(PageBean pb, Long districtId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("districtId", districtId);
            pb.setRows(this.deliveryPointMapper.selectAllCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.deliveryPointMapper.selectAllByPb(map));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u5206\u9875\u67e5\u8be2\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<DeliveryPoint> selectDeliveryPointByDistrictIdForSite(Long districtId) {
        List<DeliveryPoint> list = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("districtId", districtId);
        try {
            list = this.deliveryPointMapper.selectByDistrictIdForSite(map);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u524d\u53f0\u67e5\u8be2\u81ea\u63d0\u70b9\u5f02\u5e38\uff1a=>", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DeliveryPoint> selectDeliveryPointBycityId(Long cityId) {
        List<DeliveryPoint> list = null;
        List<DistrictVo> disvo = this.districtService.queryDistrictByCityId(cityId);
        if (CollectionUtils.isNotEmpty(disvo)) {
            list = this.deliveryPointMapper.selectDeliveryPointBydistrictIds(disvo);
        }
        return list;
    }

    @Override
    public int changeUserdStatus(Long districtId) {
        int n = -1;
        try {
            DeliveryPoint dp = this.deliveryPointMapper.selectByPrimaryKey(districtId);
            if ("0".equals(dp.getIsUserd())) {
                dp.setIsUserd("1");
            } else {
                dp.setIsUserd("0");
            }
            dp.setUpdateDate(new Date());
            n = this.deliveryPointMapper.updateByPrimaryKeySelective(dp);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u4fee\u6539\u81ea\u63d0\u70b9\u7684\u542f\u7528\u72b6\u6001", (Throwable)e);
        }
        return n;
    }

    @Override
    public List<DeliveryPoint> selectByCityId(Long cityId) {
        List<DeliveryPoint> result = this.deliveryPointMapper.selectByCityId(cityId);
        return result;
    }

    @Override
    public Long deliveryCountOfCity(Long cityId) {
        Long count = this.deliveryPointMapper.deliveryCountOfCity(cityId);
        return count;
    }
}

