/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.bean.GoodsSiteSearchBean;
import com.qianjiang.channel.dao.ChannelStoreyGoodsMapper;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ChannelStoreyGoodsService")
public class ChannelStoreyGoodsServiceImpl
implements ChannelStoreyGoodsService {
    private static final String STOREYID = "storeyId";
    private static final String STOREYTAGID = "storeyTagId";
    private static final String ISHOT = "isHot";
    private static final String DISTINCTID = "distinctId";
    private ChannelStoreyGoodsMapper storeyGoodsMapper;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;

    @Override
    public int deleteChannelStoreyGoods(Long channelStoreyGoodsproductId, Long userId) {
        ChannelStoreyGoods storeyGoods = this.storeyGoodsMapper.selectByPrimaryKey(channelStoreyGoodsproductId);
        storeyGoods.setDelflag("1");
        storeyGoods.setUpdateUserId(userId);
        storeyGoods.setUpdateDate(new Date());
        return this.storeyGoodsMapper.updateByPrimaryKeySelective(storeyGoods);
    }

    @Override
    public int saveChannelStoreyGoods(ChannelStoreyGoods record) {
        record.setDelflag("0");
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.storeyGoodsMapper.insertSelective(record);
    }

    @Override
    public int updateChannelStoreyGoods(ChannelStoreyGoods record) {
        record.setUpdateDate(new Date());
        return this.storeyGoodsMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public ChannelStoreyGoods getChannelStoreyGoodsById(Long channelStoreyGoodsproductId) {
        return this.storeyGoodsMapper.selectByPrimaryKey(channelStoreyGoodsproductId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectchannelStoreyGoodsByParam(PageBean pb, Long storeyId, Long storeyTagId, String isHot) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(STOREYID, storeyId);
            map.put(STOREYTAGID, storeyTagId);
            map.put(ISHOT, isHot);
            pb.setRows(this.storeyGoodsMapper.selectchannelStoreyGoodsCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.storeyGoodsMapper.selectchannelStoreyGoodsByParam(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<ChannelStoreyGoods> selectchannelStoreyGoodsByParamForChannelSite(Long distinctId, Long storeyId, Long storeyTagId, String isHot, GoodsSiteSearchBean searchBean, PageBean pageBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STOREYID, storeyId);
        map.put(STOREYTAGID, storeyTagId);
        map.put(ISHOT, isHot);
        map.put("searchBean", searchBean);
        if (pageBean != null) {
            pageBean.setRows(this.storeyGoodsMapper.selectchannelStoreyGoodsNumberByParam(map));
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            if (null == distinctId) {
                Long dId = this.addressService.getDefaultIdService();
                if (dId == null && (distinctId = this.addressService.getDefaultIdService()) == null) {
                    distinctId = 749L;
                }
                map.put(DISTINCTID, dId);
                List<Object> goods = this.storeyGoodsMapper.selectchannelStoreyGoodsByParamForChannelSite(map);
                pageBean.setList(goods);
            } else {
                map.put(DISTINCTID, distinctId);
                List<Object> goods = this.storeyGoodsMapper.selectchannelStoreyGoodsByParamForChannelSite(map);
                pageBean.setList(goods);
            }
        }
        return this.storeyGoodsMapper.selectchannelStoreyGoodsByParamForSite(map);
    }

    @Override
    public List<ChannelStoreyGoods> selectchannelStoreyGoodsByParamForSite(Long storeyId, Long storeyTagId, String isHot) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STOREYID, storeyId);
        map.put(STOREYTAGID, storeyTagId);
        map.put(ISHOT, isHot);
        return this.storeyGoodsMapper.selectchannelStoreyGoodsByParamForSite(map);
    }

    public ChannelStoreyGoodsMapper getStoreyGoodsMapper() {
        return this.storeyGoodsMapper;
    }

    @Resource(name="ChannelStoreyGoodsMapper")
    public void setStoreyGoodsMapper(ChannelStoreyGoodsMapper storeyGoodsMapper) {
        this.storeyGoodsMapper = storeyGoodsMapper;
    }
}

