/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.dao.SysChannelMapper;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="SysChannelService")
public class SysChannelServiceImpl
implements SysChannelService {
    private SysChannelMapper channelMapper;

    public SysChannelMapper getChannelMapper() {
        return this.channelMapper;
    }

    @Resource(name="SysChannelMapper")
    public void setChannelMapper(SysChannelMapper channelMapper) {
        this.channelMapper = channelMapper;
    }

    @Override
    public int deleteChannel(Long channelId, Long userID) {
        Channel channel = this.channelMapper.selectByPrimaryKey(channelId);
        channel.setUpdateUserId(userID);
        channel.setDelflag("1");
        channel.setUpdateDate(new Date());
        return this.channelMapper.updateByPrimaryKeySelective(channel);
    }

    @Override
    public int createChannel(Channel record) {
        record.setDelflag("0");
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.channelMapper.insertSelective(record);
    }

    @Override
    public int updateChannel(Channel record) {
        record.setUpdateDate(new Date());
        return this.channelMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public Channel findChannelByID(Long channelId) {
        return this.channelMapper.selectByPrimaryKey(channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findChannelByPageBean(PageBean pb, String searchText, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("searchText", searchText);
            map.put("tempId", tempId);
            pb.setRows(this.channelMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.channelMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public void closeAllChannel() {
        List<Channel> list = this.channelMapper.selectAll();
        for (Channel channel : list) {
            channel.setUsedStart("0");
            channel.setUpdateDate(new Date());
            this.channelMapper.updateByPrimaryKeySelective(channel);
        }
    }

    @Override
    public void openAllChannel() {
        List<Channel> list = this.channelMapper.selectAll();
        for (Channel channel : list) {
            channel.setUsedStart("1");
            channel.setUpdateDate(new Date());
            this.channelMapper.updateByPrimaryKeySelective(channel);
        }
    }

    @Override
    public void openChannelByID(Long channelId, Long userId) {
        Channel channel = this.channelMapper.selectByPrimaryKey(channelId);
        channel.setUsedStart("1");
        channel.setUpdateUserId(userId);
        channel.setUpdateDate(new Date());
        this.channelMapper.updateByPrimaryKeySelective(channel);
    }

    @Override
    public void closeChannelByID(Long channelId, Long userId) {
        Channel channel = this.channelMapper.selectByPrimaryKey(channelId);
        channel.setUsedStart("0");
        channel.setUpdateUserId(userId);
        channel.setUpdateDate(new Date());
        this.channelMapper.updateByPrimaryKeySelective(channel);
    }

    @Override
    public Channel selectByCateId(Long cateId) {
        return this.channelMapper.selectByCateId(cateId);
    }

    @Override
    public Channel selectByBarId(String barId) {
        return this.channelMapper.selectByBarId(barId);
    }
}

