/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.InforSubjectClassify;
import com.qianjiang.information.dao.InforSubjectClassifyMapper;
import com.qianjiang.information.service.InforSubjectClassifyService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InforSubjectClassifyServiceImpl")
public class InforSubjectClassifyServiceImpl
implements InforSubjectClassifyService {
    @Resource(name="InforSubjectClassifyMapperImpl")
    private InforSubjectClassifyMapper kindClassMapper;
    @Resource
    private RedisAdapter redisAdapter;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public PageBean findByPageBean(PageBean pb, SelectBean selectBean) {
        pb.setRows(this.kindClassMapper.findTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        map.put("helpCateStatus", selectBean.getHelpCateStatus());
        map.put("helpCateType", selectBean.getHelpCateType());
        pb.setList(this.kindClassMapper.findByPageBean(map));
        return pb;
    }

    @Override
    public int insertHelpCate(InforSubjectClassify helpCate) {
        helpCate.setDelFlag("0");
        this.redisAdapter.delete("HELPCATELIST_KEY");
        return this.kindClassMapper.insertSelective(helpCate);
    }

    @Override
    public int deleteHelpCate(String helpcateId) {
        int count = 0;
        if (helpcateId != null) {
            count = this.kindClassMapper.deleteByPrimaryKey(Long.parseLong(helpcateId));
        }
        this.redisAdapter.delete("CLASSKIND_KEY");
        return count;
    }

    @Override
    public InforSubjectClassify findByHelpcateId(Long helpcateId) {
        return this.kindClassMapper.selectByPrimaryKey(helpcateId);
    }

    @Override
    public int updateHelpCate(InforSubjectClassify inforSubjectClassify) {
        inforSubjectClassify.setModifyTime(this.df.format(new Date()));
        this.redisAdapter.delete("CLASSKIND_KEY");
        return this.kindClassMapper.updateByPrimaryKeySelective(inforSubjectClassify);
    }

    @Override
    public List<InforSubjectClassify> findAll() {
        return this.kindClassMapper.findAll();
    }

    @Override
    public List<InforSubjectClassify> findClassKindList(Long helpcateType) {
        return this.kindClassMapper.findClassKindList(helpcateType);
    }

    @Override
    public InforSubjectClassify selectByPrimaryKey(Long ThemaClassFicationCateId) {
        return this.kindClassMapper.selectByPrimaryKey(ThemaClassFicationCateId);
    }
}

