/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.bean.SysBasic;
import com.qianjiang.system.dao.BasicSetMapper;
import com.qianjiang.system.dao.SysBasicMapper;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.uploadfileset.bean.UploadFileSet;
import com.qianjiang.uploadfileset.dao.UploadFileSetMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageRowsUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="basicSetService")
public class BasicSetServiceImpl
implements BasicSetService {
    private static final MyLogger LOGGER = new MyLogger(BasicSetServiceImpl.class);
    @Resource(name="basicSetMapper")
    private BasicSetMapper basicSetMapper;
    @Resource(name="SysBasicMapper")
    private SysBasicMapper sysBasicMapper;
    @Resource(name="UploadFileSetMapper")
    private UploadFileSetMapper uploadFileSetMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public BasicSet findBasicSet() {
        BasicSet basicSet = (BasicSet)this.redisAdapter.get("BASICSET_KEY");
        if (null != basicSet) {
            return basicSet;
        }
        basicSet = this.basicSetMapper.findBasicSet();
        this.redisAdapter.put("BASICSET_KEY", basicSet);
        return basicSet;
    }

    @Override
    public int updateBasicSet(BasicSet basicSet) {
        this.redisAdapter.delete("BASICSET_KEY");
        return this.basicSetMapper.updateByPrimaryKeySelective(basicSet);
    }

    @Override
    public String getStoreStatus() {
        return this.basicSetMapper.getStoreStatus();
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Map<String, Object> saveManagerSet(SysBasic sysBasic, UploadFileSet ufs, Integer pageRows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        try {
            this.sysBasicMapper.updateByPrimaryKeySelective(sysBasic);
            PageRowsUtil.setPageRows(pageRows);
            this.uploadFileSetMapper.updateByPrimaryKeySelective(ufs);
            resultMap.put("result", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5e73\u53f0\u57fa\u672c\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25" + e.getMessage(), e);
        }
        return resultMap;
    }
}

