/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Empower;
import com.qianjiang.system.bean.EmpowerLog;
import com.qianjiang.system.dao.EmpowerMapper;
import com.qianjiang.system.service.EmpowerService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="EmpowerService")
public class EmpowerServiceImpl
implements EmpowerService {
    @Resource(name="EmpowerMapper")
    private EmpowerMapper empowerMapper;

    @Override
    public PageBean list(PageBean pageBean) {
        pageBean.setRows(this.empowerMapper.listCount());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("start", pageBean.getStartRowNum());
        map.put("end", pageBean.getEndRowNum());
        pageBean.setList(this.empowerMapper.list(map));
        return pageBean;
    }

    @Override
    public int insertEmpower(Empower empower) {
        String base = "ABCDEFGHIJKLMNGPQRSTUVWXYZ";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        empower.setAppKey(sb.toString());
        return this.empowerMapper.insertEmpower(empower);
    }

    @Override
    public int updateEmpower(String status, Long appId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("appId", appId);
        return this.empowerMapper.updateEmpower(map);
    }

    @Override
    public int delEmpower(Long appId) {
        return this.empowerMapper.delEmpower(appId);
    }

    @Override
    public int checkUserName(String appUserName) {
        return this.empowerMapper.checkName(appUserName);
    }

    @Override
    public List<EmpowerLog> selectLog(Long empowerId) {
        return this.empowerMapper.selectLog(empowerId);
    }
}

