/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.AnalyzeContext;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.ISegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.Lexeme;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Dictionary;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Hit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class CNQuantifierSegmenter
implements ISegmenter {
    static final String SEGMENTER_NAME = "QUAN_SEGMENTER";
    private static String Chn_Num;
    private static Set<Character> ChnNumberChars;
    private int nStart = -1;
    private int nEnd = -1;
    private List<Hit> countHits = new LinkedList<Hit>();

    CNQuantifierSegmenter() {
    }

    @Override
    public void analyze(AnalyzeContext context) {
        this.processCNumber(context);
        this.processCount(context);
        if (this.nStart == -1 && this.nEnd == -1 && this.countHits.isEmpty()) {
            context.unlockBuffer(SEGMENTER_NAME);
        } else {
            context.lockBuffer(SEGMENTER_NAME);
        }
    }

    @Override
    public void reset() {
        this.nStart = -1;
        this.nEnd = -1;
        this.countHits.clear();
    }

    private void processCNumber(AnalyzeContext context) {
        if (this.nStart == -1 && this.nEnd == -1) {
            if (4 == context.getCurrentCharType() && ChnNumberChars.contains(Character.valueOf(context.getCurrentChar()))) {
                this.nStart = context.getCursor();
                this.nEnd = context.getCursor();
            }
        } else if (4 == context.getCurrentCharType() && ChnNumberChars.contains(Character.valueOf(context.getCurrentChar()))) {
            this.nEnd = context.getCursor();
        } else {
            this.outputNumLexeme(context);
            this.nStart = -1;
            this.nEnd = -1;
        }
        if (context.isBufferConsumed() && this.nStart != -1 && this.nEnd != -1) {
            this.outputNumLexeme(context);
            this.nStart = -1;
            this.nEnd = -1;
        }
    }

    private void processCount(AnalyzeContext context) {
        if (!this.needCountScan(context)) {
            return;
        }
        if (4 == context.getCurrentCharType()) {
            Hit singleCharHit;
            if (!this.countHits.isEmpty()) {
                Hit[] tmpArray;
                for (Hit hit : tmpArray = this.countHits.toArray(new Hit[this.countHits.size()])) {
                    hit = Dictionary.getSingleton().matchWithHit(context.getSegmentBuff(), context.getCursor(), hit);
                    if (hit.isMatch()) {
                        Lexeme newLexeme = new Lexeme(context.getBufferOffset(), hit.getBegin(), context.getCursor() - hit.getBegin() + 1, 32);
                        context.addLexeme(newLexeme);
                        if (hit.isPrefix()) continue;
                        this.countHits.remove(hit);
                        continue;
                    }
                    if (!hit.isUnmatch()) continue;
                    this.countHits.remove(hit);
                }
            }
            if ((singleCharHit = Dictionary.getSingleton().matchInQuantifierDict(context.getSegmentBuff(), context.getCursor(), 1)).isMatch()) {
                Lexeme newLexeme = new Lexeme(context.getBufferOffset(), context.getCursor(), 1, 32);
                context.addLexeme(newLexeme);
                if (singleCharHit.isPrefix()) {
                    this.countHits.add(singleCharHit);
                }
            } else if (singleCharHit.isPrefix()) {
                this.countHits.add(singleCharHit);
            }
        } else {
            this.countHits.clear();
        }
        if (context.isBufferConsumed()) {
            this.countHits.clear();
        }
    }

    private boolean needCountScan(AnalyzeContext context) {
        Lexeme l;
        if (this.nStart != -1 && this.nEnd != -1 || !this.countHits.isEmpty()) {
            return true;
        }
        return !context.getOrgLexemes().isEmpty() && (16 == (l = context.getOrgLexemes().peekLast()).getLexemeType() || 2 == l.getLexemeType()) && l.getBegin() + l.getLength() == context.getCursor();
    }

    private void outputNumLexeme(AnalyzeContext context) {
        if (this.nStart > -1 && this.nEnd > -1) {
            Lexeme newLexeme = new Lexeme(context.getBufferOffset(), this.nStart, this.nEnd - this.nStart + 1, 16);
            context.addLexeme(newLexeme);
        }
    }

    static {
        char[] ca;
        Chn_Num = "\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u767e\u5343\u4e07\u4ebf\u62fe\u4f70\u4edf\u842c\u5104\u5146\u5345\u5eff";
        ChnNumberChars = new HashSet<Character>();
        for (char nChar : ca = Chn_Num.toCharArray()) {
            ChnNumberChars.add(Character.valueOf(nChar));
        }
    }
}

