/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.auth.alipay.util.httpclient;

import com.qianjiang.system.auth.alipay.util.httpclient.HttpRequest;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpResponse;
import com.qianjiang.system.auth.alipay.util.httpclient.HttpResultType;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;

public final class HttpProtocolHandler {
    public static final MyLogger LOGGER = new MyLogger(HttpProtocolHandler.class);
    private static final String DEFAULT_CHARSET = "GBK";
    private static final int DEFAULTCONNECTIONTIMEOUT = 8000;
    private static final int DEFAULTSOTIMEOUT = 30000;
    private static final int DEFAULTIDLECONNTIMEOUT = 60000;
    private static final int DEFAULTMAXCONNPERHOST = 30;
    private static final int DEFAULTMAXTOTALCONN = 80;
    private static final long DEFAULTHTTPCONNECTIONMANAGERTIMEOUT = 3000L;
    private HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static HttpProtocolHandler httpProtocolHandler = new HttpProtocolHandler();

    private HttpProtocolHandler() {
        this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(30);
        this.connectionManager.getParams().setMaxTotalConnections(80);
        IdleConnectionTimeoutThread ict = new IdleConnectionTimeoutThread();
        ict.addConnectionManager(this.connectionManager);
        ict.setConnectionTimeout(60000L);
        ict.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest request) {
        HttpClient httpclient = new HttpClient(this.connectionManager);
        int connectionTimeout = 8000;
        if (request.getConnectionTimeout() > 0) {
            connectionTimeout = request.getConnectionTimeout();
        }
        httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        int soTimeout = 30000;
        if (request.getTimeout() > 0) {
            soTimeout = request.getTimeout();
        }
        httpclient.getHttpConnectionManager().getParams().setSoTimeout(soTimeout);
        httpclient.getParams().setConnectionManagerTimeout(3000L);
        String charset = request.getCharset();
        charset = charset == null ? DEFAULT_CHARSET : charset;
        GetMethod method = null;
        if (request.getMethod().equals("GET")) {
            method = new GetMethod(request.getUrl());
            method.getParams().setCredentialCharset(charset);
            method.setQueryString(request.getQueryString());
        } else {
            method = new PostMethod(request.getUrl());
            ((PostMethod)method).addParameters(request.getParameters());
            method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=" + charset);
        }
        method.addRequestHeader("User-Agent", "Mozilla/4.0");
        HttpResponse response = new HttpResponse();
        try {
            httpclient.executeMethod((HttpMethod)method);
            if (request.getResultType().equals((Object)HttpResultType.STRING)) {
                response.setStringResult(method.getResponseBodyAsString());
            } else if (request.getResultType().equals((Object)HttpResultType.BYTES)) {
                response.setByteResult(method.getResponseBody());
            }
            response.setResponseHeaders(method.getResponseHeaders());
        }
        catch (UnknownHostException ex) {
            LOGGER.error("", ex);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        catch (IOException ex) {
            LOGGER.error("", ex);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        catch (Exception ex) {
            LOGGER.error("", ex);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    protected String toString(NameValuePair[] nameValues) {
        if (nameValues == null || nameValues.length == 0) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nameValues.length; ++i) {
            NameValuePair nameValue = nameValues[i];
            if (i == 0) {
                buffer.append(nameValue.getName());
                buffer.append("=");
                buffer.append(nameValue.getValue());
                continue;
            }
            buffer.append("&");
            buffer.append(nameValue.getName());
            buffer.append("=");
            buffer.append(nameValue.getValue());
        }
        return buffer.toString();
    }

    public static HttpProtocolHandler getInstance() {
        return httpProtocolHandler;
    }
}

