/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.dao.ChannelAdverMapper;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChannelAdverService")
public class ChannelAdverServiceImpl
implements ChannelAdverService {
    private static final MyLogger LOGGER = new MyLogger(ChannelAdverServiceImpl.class);
    private static final String CHANNELID = "channelId";
    private static final String TEMPID = "tempId";
    private static final String ADVER_TYPE = "adverType";
    private static final String TEMP1 = "temp1";
    private static final String TEMP3 = "temp3";
    private static final Long ATID = 161L;
    private static final Long ADVERTYPE = 151L;
    @Resource(name="ChannelAdverMapper")
    private ChannelAdverMapper channelAdverMapper;
    @Autowired
    private RedisAdapter redisAdapter;

    @Override
    public int deleteChannelAdver(Long channelAdverId, Long userId) {
        ChannelAdver ca = this.channelAdverMapper.selectByPrimaryKey(channelAdverId);
        ca.setDelflag("1");
        ca.setUpdateUserId(userId);
        ca.setUpdateDate(new Date());
        this.redisAdapter.delete("CHANNELADVER_KEY");
        return this.channelAdverMapper.updateByPrimaryKeySelective(ca);
    }

    @Override
    public int saveChannelAdver(ChannelAdver record) {
        record.setDelflag("0");
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        this.redisAdapter.delete("CHANNELADVER_KEY");
        return this.channelAdverMapper.insertSelective(record);
    }

    @Override
    public int updateChannelAdver(ChannelAdver record) {
        record.setUpdateDate(new Date());
        this.redisAdapter.delete("CHANNELADVER_KEY");
        return this.channelAdverMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public ChannelAdver selectByPrimaryKey(Long channelAdverId) {
        return this.channelAdverMapper.selectByPrimaryKey(channelAdverId);
    }

    @Override
    public PageBean selectchannelAdverByParam(PageBean pb, Long channelId, Long tempId, Long floorId, Long floorTagId, Long atId, Long adverType, String temp1, String temp4) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(CHANNELID, channelId);
            map.put(TEMPID, tempId);
            map.put("floorId", floorId);
            map.put("floorTagId", floorTagId);
            map.put("atId", atId);
            map.put(ADVER_TYPE, adverType);
            map.put(TEMP1, temp1);
            map.put(TEMP3, "0");
            map.put("temp4", temp4);
            pb.setRows(this.channelAdverMapper.selectchannelAdverCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            List<Object> list = this.channelAdverMapper.selectchannelAdverByParam(map);
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(0);
                ChannelAdver channelAdver = (ChannelAdver)obj;
                String adverTitie = channelAdver.getAdverTitle();
                pb.setData(adverTitie);
            }
            pb.setList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u9875\u53c2\u6570\u548c\u9891\u9053ID\u3001\u6a21\u677fID\u3001\u697c\u5c42ID\u3001\u697c\u5c42\u6807\u7b7eID\u3001\u5206\u7c7b\u5bfc\u822aID\u67e5\u8be2\u9891\u9053\u5e7f\u544a\u5931\u8d25" + e.getMessage(), e);
        }
        return pb;
    }

    @Override
    public PageBean selectClassifyBarAdverByParam(PageBean pb, Long tempId, Long channelId, String temp1, String temp3) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(CHANNELID, channelId);
            map.put(TEMPID, tempId);
            map.put("atId", ATID);
            map.put(ADVER_TYPE, ADVERTYPE);
            map.put(TEMP1, temp1);
            map.put(TEMP3, temp3);
            pb.setRows(this.channelAdverMapper.selectchannelAdverCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.channelAdverMapper.selectchannelAdverByParam(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u9875\u53c2\u6570\u3001\u5206\u7c7b\u5bfc\u822aID\u67e5\u8be2\u5bfc\u822a\u5206\u7c7b\u7236\u6846\u5e7f\u544a\u5931\u8d25" + e.getMessage(), e);
        }
        return pb;
    }

    @Override
    public List<ChannelAdver> selectchannelAdverByParamForSite(Long channelId, Long tempId, Long floorId, Long floorTagId, Long atId, Long adverType, String temp1, String temp3, String temp4, String temp5) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNELID, channelId);
        map.put(TEMPID, tempId);
        map.put("floorId", floorId);
        map.put("floorTagId", floorTagId);
        map.put("atId", atId);
        map.put(ADVER_TYPE, adverType);
        map.put(TEMP1, temp1);
        map.put(TEMP3, temp3);
        map.put("temp4", temp4);
        map.put("temp5", temp5);
        return this.channelAdverMapper.selectchannelAdverByParamForSite(map);
    }
}

