/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.dao.CustomerCommissionLogMapper;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerCommissionService;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerCommissionService")
public class CustomerCommissionServiceImpl
implements CustomerCommissionService {
    public static final MyLogger LOGGER = new MyLogger(CustomerCommissionServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private CustomerCommissionLogMapper customerCommissionLogMapper;
    @Autowired
    private CustomerMapper customerMapper;

    @Override
    public void getCustomerCommission(Long customerId, Date payTime, String orderCode) {
        Long pid = this.customerMapper.getPidByCustomerId(customerId);
        if (pid == null) {
            return;
        }
        Long pidStatus = this.customerMapper.selectSuperiorByPid(pid);
        if (pidStatus == 0L) {
            return;
        }
        int firstStatus = this.orderMapper.countFirstOrder(customerId, payTime);
        if (firstStatus == 0) {
            Order order = this.orderMapper.countPidCommission(customerId, orderCode);
            BigDecimal superiorCustomerCommission = order.getSuperiorCustomerCommission().setScale(2, RoundingMode.UP);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", order.getCustomerId());
            paramMap.put("pid", pid);
            paramMap.put("orderCode", order.getOrderCode());
            paramMap.put("orderPrice", order.getOrderPrice());
            paramMap.put("superiorCustomerCommission", superiorCustomerCommission);
            this.customerCommissionLogMapper.insertCustomerCommissionLog(paramMap);
            this.customerMapper.updateCustomerCommission(pid, superiorCustomerCommission);
            return;
        }
        Order order = this.orderMapper.countNoFirstCommission(customerId, orderCode);
        BigDecimal superiorCustomerCommission = order.getSuperiorCustomerCommission().setScale(2, RoundingMode.UP);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", order.getCustomerId());
        paramMap.put("pid", pid);
        paramMap.put("orderCode", order.getOrderCode());
        paramMap.put("orderPrice", order.getOrderPrice());
        paramMap.put("superiorCustomerCommission", superiorCustomerCommission);
        this.customerCommissionLogMapper.insertCustomerCommissionLog(paramMap);
        this.customerMapper.updateCustomerCommission(pid, superiorCustomerCommission);
    }

    @Override
    public BigDecimal selectCustomerCommissionById(Long customerId) {
        BigDecimal customerCommission = this.customerMapper.selectCustomerCommissionById(customerId);
        return customerCommission;
    }
}

