/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.Browserecord;
import com.qianjiang.customer.dao.BrowserecordMapper;
import com.qianjiang.customer.service.GuessLikeGoodsService;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.mgoods.dao.GoodsMapper;
import com.qianjiang.mgoods.dao.GoodsProductMapper;
import com.qianjiang.mgoods.dao.ProductWareMapper;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.thirdaudit.bean.GoodsProduct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="guessLikeGoodsService")
public class GuessLikeGoodsServiceImpl
implements GuessLikeGoodsService {
    private static final String CUSTOMERID = "customerId";
    @Resource(name="browserecordMapper1")
    private BrowserecordMapper browserecordMapper;
    @Resource(name="HsiteGoodsMapper")
    private GoodsMapper goodsMapper;
    @Resource(name="HsiteGoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService defaultAddressService;
    @Resource(name="ProductWareMapper1")
    private ProductWareMapper productWareMapper;

    @Override
    public List<GoodsProduct> guessLikeGoodsList(Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, customerId);
        paramMap.put("isMobile", 1);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 20);
        List<Object> browereList = this.browserecordMapper.selectBrowserecord(paramMap);
        ArrayList<Long> cateIds = new ArrayList<Long>();
        if (browereList != null && !browereList.isEmpty()) {
            for (int i = 0; i < browereList.size(); ++i) {
                Browserecord browserecord = (Browserecord)browereList.get(i);
                GoodsProduct goodsProductT = this.goodsProductMapper.queryByGoodsInfoDetail(new Long(browserecord.getGoodsId().intValue()));
                if (goodsProductT == null) continue;
                long cateId = this.goodsMapper.selectByGoodsId(goodsProductT.getGoodsId());
                cateIds.add(cateId);
            }
        }
        List<GoodsProduct> goodsProducts = new ArrayList<GoodsProduct>();
        if (!cateIds.isEmpty()) {
            HashSet catSet = new HashSet(cateIds);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("catIds", catSet);
            List<Long> goodInfoIds = this.goodsProductMapper.queryGoodsInfoIdsByCatIds(map);
            if (null != goodInfoIds && goodInfoIds.size() > 0) {
                map.put("goodInfoIds", goodInfoIds);
                goodsProducts = this.goodsProductMapper.queryGoodsInfoByGoodInfoIds(map);
                for (GoodsProduct goodsProduct : goodsProducts) {
                    if (goodsProduct == null) continue;
                    if (goodsProduct.getIsThird() != null && !"".equals(goodsProduct.getIsThird()) && "1".equals(goodsProduct.getIsThird())) {
                        goodsProduct.setGoodsInfoStock(goodsProduct.getGoodsInfoStock());
                        continue;
                    }
                    Long distinctId = this.defaultAddressService.getDefaultIdService();
                    if (distinctId == null) {
                        distinctId = 749L;
                    }
                    HashMap<String, Long> param = new HashMap<String, Long>();
                    param.put("productId", new Long(goodsProduct.getGoodsInfoId()));
                    param.put("distinctId", distinctId);
                    ProductWare productWare = this.productWareMapper.queryProductWareByProductIdAndDistinctId(param);
                    if (productWare == null) continue;
                    goodsProduct.setGoodsInfoStock(productWare.getWareStock());
                }
            }
        }
        return goodsProducts;
    }
}

