/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.ningpai.wxpay.utils.TenpayUtil;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.dao.DepositInfoMapper;
import com.qianjiang.customer.dao.TradeInfoMapper;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.customer.service.impl.DepositInfoServiceImpl;
import com.qianjiang.customer.vo.DepositInfoVo;
import com.qianjiang.deposit.vo.TradeInfoVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tradeInfoServiceImpl")
public class TradeInfoServiceImpl
implements TradeInfoService {
    public static final MyLogger LOGGER = new MyLogger(DepositInfoServiceImpl.class);
    @Resource(name="TradeInfoMapperImpl")
    private TradeInfoMapper tradeInfoMapper;
    @Resource(name="DepositInfoMapperM")
    private DepositInfoMapper depositInfoMapper;

    @Override
    public Long selectTotalTradeInfo(DepositInfoVo depositInfoVo) {
        Long result = null;
        LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u9884\u5b58\u6b3e\u660e\u7ec6\u603b\u6570\u636e\u6761\u6570...");
        try {
            result = this.tradeInfoMapper.selectTotalTradeInfo(depositInfoVo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @Override
    public PageBean selectTradeInfoList(DepositInfoVo depositInfoVo, PageBean pageBean) {
        Long rowNos = this.selectTotalTradeInfo(depositInfoVo);
        pageBean.setRows(rowNos.intValue());
        depositInfoVo.setStartRowNum(pageBean.getStartRowNum());
        depositInfoVo.setEndRowNum(pageBean.getEndRowNum());
        try {
            LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u9884\u5b58\u6b3e\u660e\u7ec6\u5217\u8868...");
            List<Object> tradeInfoList = this.tradeInfoMapper.selectTradeInfoList(depositInfoVo);
            if (CollectionUtils.isNotEmpty(tradeInfoList)) {
                pageBean.setList(tradeInfoList);
            }
            pageBean.setObjectBean(depositInfoVo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return pageBean;
    }

    @Override
    @Transactional
    public int insertTradeInfo(TradeInfo tradeInfo) {
        return this.tradeInfoMapper.insertTradeInfo(tradeInfo);
    }

    @Override
    @Transactional
    public int updateTradeInfo(TradeInfo tradeInfo) {
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setTradeSource("\u63d0\u73b0");
        return this.tradeInfoMapper.updateTradeInfo(tradeInfo);
    }

    @Override
    @Transactional
    public int batchUpdateTradeInfo(TradeInfo tradeInfo) {
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setTradeSource("\u63d0\u73b0");
        return this.tradeInfoMapper.batchUpdateTradeInfo(tradeInfo);
    }

    @Override
    public TradeInfo getTradeInfoById(Long tradeInfoId) {
        TradeInfo tradeInfo = new TradeInfo();
        try {
            LOGGER.info("\u6839\u636eID\u67e5\u8be2\u4ea4\u6613\u4fe1\u606f");
            DepositInfoVo depositInfo = new DepositInfoVo();
            depositInfo.setTradeInfoId(tradeInfoId);
            depositInfo.setEndRowNum(1);
            tradeInfo = this.tradeInfoMapper.getTradeInfoById(depositInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return tradeInfo;
    }

    @Override
    public PageBean queryTradeInfo(PageBean pageBean, Map<String, Object> map) {
        pageBean.setPageSize(8);
        pageBean.setRows(this.tradeInfoMapper.queryTradeInfoPageRows(map).intValue());
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.tradeInfoMapper.queryTradeInfoPage(map));
        return pageBean;
    }

    @Override
    public TradeInfo insertSelective(Long customerId, BigDecimal orderPrice, String orderType, String payType, String remark, DepositInfo depositInfo) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setOrderType(orderType);
        tradeInfo.setOrderCode(this.genenrateTradeCode(payType));
        tradeInfo.setCreatePerson(customerId);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setCurrentPrice(depositInfo.getPreDeposit().add(depositInfo.getFreezePreDeposit()));
        if ("0".equals(orderType)) {
            tradeInfo.setOrderStatus("5");
        } else if ("2".equals(orderType)) {
            tradeInfo.setOrderStatus("0");
        }
        if (StringUtils.isNotEmpty((String)remark)) {
            tradeInfo.setTradeRemark(remark);
        }
        if (this.tradeInfoMapper.insertSelective(tradeInfo) > 0) {
            return tradeInfo;
        }
        return null;
    }

    private String genenrateTradeCode(String orderType) {
        String tradeCode = "";
        String nonceStr = TenpayUtil.buildRandom((int)4) + "";
        String currTime = TenpayUtil.getCurrTime();
        if ("0".equals(orderType)) {
            tradeCode = "R" + currTime + nonceStr;
        } else if ("2".equals(orderType)) {
            tradeCode = "W" + currTime + nonceStr;
        }
        return tradeCode;
    }

    @Override
    public TradeInfo selectByTradeNo(String tradeNo) {
        return this.tradeInfoMapper.selectByTradeNo(tradeNo);
    }

    @Override
    public PageBean queryWithdraw(PageBean pageBean, Map<String, Object> map) {
        pageBean.setPageSize(8);
        pageBean.setRows(this.tradeInfoMapper.queryWithdrawPageRows(map).intValue());
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.tradeInfoMapper.queryWithdrawPage(map));
        return pageBean;
    }

    @Override
    public TradeInfoVo queryTradeInfoById(Long id) {
        TradeInfoVo tradeInfoVo = this.tradeInfoMapper.queryTradeInfoById(id);
        return tradeInfoVo;
    }

    @Override
    public boolean updateTradeInfoStatus(Long customerId, Long tradeInfoId, String type) {
        boolean result = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", customerId);
        map.put("type", type);
        map.put("tradeInfoId", tradeInfoId);
        if ("0".equals(type)) {
            map.put("orderStatus", "8");
        } else if ("3".equals(type)) {
            DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
            TradeInfoVo tradeInfoVo = this.tradeInfoMapper.queryTradeInfoById(tradeInfoId);
            map.put("currentPrice", depositInfo.getFreezePreDeposit().add(depositInfo.getPreDeposit()).subtract(tradeInfoVo.getOrderPrice()));
            map.put("orderStatus", "4");
        }
        int num = this.tradeInfoMapper.updateTradeInfoStatus(map);
        LOGGER.info("\u4fee\u6539\u63d0\u73b0\u72b6\u6001============================num:" + num);
        if (num > 0) {
            this.updateDeposit(type, customerId, tradeInfoId);
            result = true;
        }
        return result;
    }

    private int updateDeposit(String type, Long customerId, Long tradeInfoId) {
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        TradeInfoVo tradeInfoVo = this.tradeInfoMapper.queryTradeInfoById(tradeInfoId);
        DepositInfo updateDeposit = new DepositInfo();
        updateDeposit.setCustomerId(customerId);
        if ("0".equals(type)) {
            updateDeposit.setFreezePreDeposit(depositInfo.getFreezePreDeposit().subtract(tradeInfoVo.getOrderPrice()));
            updateDeposit.setPreDeposit(depositInfo.getPreDeposit().add(tradeInfoVo.getOrderPrice()));
        } else if ("3".equals(type)) {
            updateDeposit.setFreezePreDeposit(depositInfo.getFreezePreDeposit().subtract(tradeInfoVo.getOrderPrice()));
        }
        return this.depositInfoMapper.updateDepositInfo(updateDeposit);
    }

    @Override
    public TradeInfoVo queryByIdAndCusId(Long id, Long customerId) {
        TradeInfoVo tradeInfo = new TradeInfoVo();
        if (id != null && customerId != null) {
            tradeInfo.setCustomerId(customerId);
            tradeInfo.setId(id);
            return this.tradeInfoMapper.queryByIdAndCusId(tradeInfo);
        }
        return tradeInfo;
    }
}

