/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.common.util.GenerateLinkUtils;
import com.qianjiang.customer.bean.BackOrder;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.bean.CustomerPointLevelTask;
import com.qianjiang.customer.bean.OrderGoods;
import com.qianjiang.customer.bean.WxBill;
import com.qianjiang.customer.dao.CustomerAddressMapper;
import com.qianjiang.customer.dao.CustomerFollowMapper;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.dao.CustomerPointLevelMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.dao.InsideLetterMapper;
import com.qianjiang.customer.dao.WxBillMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.CustomerSiteService;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.customer.vo.CustomerStatisticVo;
import com.qianjiang.customer.vo.SendPostMobileCode;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.order.dao.BackOrderMapper1;
import com.qianjiang.order.dao.OrderGoodsMapper1;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.other.bean.StreetBean;
import com.qianjiang.other.util.SelectBean;
import com.qianjiang.site.goods.vo.GoodsProductVo;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.sms.SmsUtil;
import com.qianjiang.utils.SecurityUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerServiceMapper")
public class CustomerServiceMapperImpl
implements CustomerServiceMapper {
    public static final MyLogger logger = new MyLogger(CustomerServiceMapper.class);
    private static final String CUSTOMERID = "customerId";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String UTYPE = "uType";
    private CustomerMapper customerMapper;
    private CustomerInfoMapper customerInfoMapper;
    @Resource(name="customerAddressMapper")
    private CustomerAddressMapper customerAddressMapper;
    private CustomerPointLevelMapper customerPointLevelMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    public static final MyLogger LOGGER = new MyLogger(CustomerServiceMapperImpl.class);
    private static final String REGEX = "^0?(13|15|17|18|14)[0-9]{9}$";
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;
    @Autowired
    private WxBillMapper wxBillMapper;
    @Resource(name="BackOrderMapper1")
    private BackOrderMapper1 backOrderMapper;
    @Resource(name="OrderGoodsMapper1")
    private OrderGoodsMapper1 orderGoodsMapper;
    @Autowired
    private CustomerFollowMapper customerFollowMapper;
    @Resource(name="insideletter")
    private InsideLetterMapper insideletter;
    @Resource(name="OrderMapper2")
    private OrderMapper orderMapper;
    @Autowired
    private CustomerPointMapper customerPointMapper;
    @Autowired
    private CustomerSiteService customerSiteService;

    @Override
    public int queryInfoCountByLevelId(Long pointLevelId) {
        return this.customerInfoMapper.queryInfoCountByLevelId(pointLevelId);
    }

    @Override
    public int modifyEmpToDisableThird(Long custId, String flag, Long thirdId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("custId", custId);
        paramMap.put("flag", flag);
        paramMap.put("thirdId", thirdId);
        return this.customerMapper.modifyEmpToDisableThird(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteCustomerThird(String[] custId, Long thirdId) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, custId);
            paramMap.put("thirdId", thirdId);
            count = this.customerMapper.deleteCustomerThird(paramMap);
        }
        finally {
            paramMap = null;
        }
        return count;
    }

    @Override
    public int updateCusErrorCount(Customer customer) {
        return this.customerMapper.updateCusErrorCount(customer);
    }

    @Override
    public int updateCusLock(Customer customer) {
        return this.customerMapper.updateCusLock(customer);
    }

    @Override
    public Customer getCustomerByUsername(String username) {
        return this.customerMapper.getCustomerByUsername(username);
    }

    @Override
    public Customer getCustomerByInput(String username) {
        return this.customerMapper.getCustomerByInput(username);
    }

    @Override
    public int deleteStore(String[] ids) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ids);
        return this.customerMapper.deleteStore(map);
    }

    @Override
    public int updateStatus(int cId) {
        return this.customerMapper.updateStatus(cId);
    }

    @Override
    public CustomerAllInfo selectByPrimaryKey(Long customerId) {
        CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(customerId);
        if (null != customerAllInfo) {
            customerAllInfo.setInfoPointSum(this.customerPointServiceMapper.getCustomerAllPoint(customerId + ""));
            CustomerPointLevel customerPointLevel = this.customerPointServiceMapper.getCustomerPointLevelByPoint(customerAllInfo.getInfoPointSum());
            if (null != customerPointLevel) {
                customerAllInfo.setPointLevelName(customerPointLevel.getPointLevelName());
            }
        }
        return customerAllInfo;
    }

    @Override
    public List<CustomerAllInfo> selectBycustomerIds(Map<String, Object> customerIds) {
        return this.customerMapper.selectBycustomerIds(customerIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllCustmer(PageBean pageBean) {
        HashMap<String, Integer> paramMap = null;
        int no = 0;
        try {
            pageBean.setRows(this.customerMapper.selectAllCustomerCount());
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            paramMap = new HashMap<String, Integer>();
            paramMap.put(STARTROWNUM, pageBean.getStartRowNum());
            paramMap.put(ENDROWNUM, pageBean.getEndRowNum());
            pageBean.setList(this.customerMapper.selectCustomerByLimit(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    @Override
    @Transactional
    public int addCustomer(CustomerAllInfo allinfo) {
        if (allinfo.getCustomerNickname() == null) {
            allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        }
        if (allinfo.getCustomerUsername() == null || "".equals(allinfo.getCustomerUsername())) {
            allinfo.setInfoMobile(allinfo.getInfoMobile());
        } else {
            allinfo.setInfoMobile(allinfo.getCustomerUsername());
        }
        allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        allinfo.setCustomerUsername(allinfo.getCustomerUsername());
        UUID uuid = UUID.randomUUID();
        allinfo.setLoginKey(uuid.toString());
        return this.customerMapper.addCustomer(allinfo);
    }

    @Override
    @Transactional
    public int addThirdCustomer(CustomerAllInfo allinfo) {
        if (allinfo.getCustomerNickname() == null) {
            allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        }
        if (allinfo.getCustomerUsername().indexOf("@") != -1) {
            allinfo.setInfoEmail(allinfo.getCustomerUsername());
            allinfo.setCustomerNickname(allinfo.getCustomerUsername().substring(0, allinfo.getCustomerUsername().indexOf("@")));
        } else if (Pattern.compile(REGEX).matcher(allinfo.getCustomerUsername()).find()) {
            allinfo.setInfoMobile(allinfo.getCustomerUsername());
            allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        }
        UUID uuid = UUID.randomUUID();
        allinfo.setLoginKey(uuid.toString());
        return this.customerMapper.addCustomer(allinfo);
    }

    @Override
    public String findStore(String customerId) {
        return this.customerMapper.findStoreId(customerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteCustomer(String[] customerId) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, customerId);
            count = this.customerMapper.deleteCustomerByIds(paramMap);
        }
        finally {
            paramMap = null;
        }
        return count;
    }

    @Override
    public String selectStatus(String customerId) {
        return this.customerMapper.selectStatus(customerId);
    }

    @Override
    @Transactional
    public int updateCustomer(CustomerAllInfo allinfo) {
        int result = this.customerMapper.updateByPrimaryKeySelective(allinfo);
        if (result == 1) {
            result = 0;
            result = this.customerInfoMapper.updateByPrimaryKeySelective(allinfo);
        }
        return result;
    }

    @Override
    public Long selectCustomerByName(String customerName) {
        return this.customerMapper.selectCustomerByName(customerName);
    }

    @Override
    public Long selectCustomerByNameForThird(String customerName) {
        return this.customerMapper.selectCustomerByNameForThird(customerName);
    }

    @Override
    public CustomerAllInfo selectCustomerOrder(Long orderId) {
        return this.customerMapper.selectCustomerOrder(orderId);
    }

    @Override
    public List<ProvinceBean> selectAllProvince() {
        return this.customerMapper.selectAllProvince();
    }

    @Override
    public List<CityBean> selectAllCityByPid(Long provinceId) {
        return this.customerMapper.selectAllCityByPid(provinceId);
    }

    @Override
    public List<DistrictBean> selectAllDistrictByCid(Long cityId) {
        return this.customerMapper.selectAllDistrictByCid(cityId);
    }

    @Override
    public PageBean selectCustmerByAllInfo(CustomerAllInfo customerAllInfo, PageBean pageBean) {
        HashMap<String, Integer> paramMap = null;
        int no = 0;
        try {
            pageBean.setRows(Integer.parseInt(this.customerMapper.selectCustmerSizeFilterThird(customerAllInfo) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (customerAllInfo != null) {
                customerAllInfo.setStartRowNum(pageBean.getStartRowNum());
                customerAllInfo.setEndRowNum(pageBean.getEndRowNum());
                pageBean.setObjectBean(customerAllInfo);
            }
            paramMap = new HashMap<String, Integer>();
            paramMap.put(STARTROWNUM, pageBean.getStartRowNum());
            paramMap.put(ENDROWNUM, pageBean.getEndRowNum());
            pageBean.setList(customerAllInfo == null ? this.customerMapper.selectCustomerByLimitFilterThird(paramMap) : this.customerMapper.selectCustmerByAllInfoFilterThird(customerAllInfo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageBean;
    }

    @Override
    public CustomerAddress queryDefaultAddr(Long customerId) {
        return this.customerAddressMapper.selectDefaultAddr(customerId);
    }

    @Override
    public CustomerAddress selectByCIdFirst(Long customerId) {
        return this.customerAddressMapper.selectByCIdFirst(customerId);
    }

    @Override
    public int updateByPrimaryKeySelective(CustomerAllInfo record) {
        return this.customerMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public List<StreetBean> getAllStreetByDid(Long dId) {
        return this.customerMapper.getAllStreetByDid(dId);
    }

    @Override
    public OrderInfoBean queryByDetail(Long orderId) {
        return this.customerMapper.queryByDetail(orderId);
    }

    @Override
    public CustomerAllInfo queryCustomerInfo(Long customerId) {
        return this.customerMapper.queryCustomerInfo(customerId);
    }

    @Override
    public int modifyEmpToDisable(Long custId, String flag) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flag", flag);
        paramMap.put("custId", custId);
        return this.customerMapper.modifyEmpToDisable(paramMap);
    }

    @Override
    public Long checkExistsByCustNameAndType(String userName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (userName.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile(REGEX).matcher(userName).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", userName);
        return this.customerMapper.checkExistsByCustNameAndType(paramMap);
    }

    public CustomerMapper getCustomerMapper() {
        return this.customerMapper;
    }

    @Resource(name="customerMapper")
    public void setCustomerMapper(CustomerMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public CustomerInfoMapper getCustomerInfoMapper() {
        return this.customerInfoMapper;
    }

    @Resource(name="customerInfoMapper")
    public void setCustomerInfoMapper(CustomerInfoMapper customerInfoMapper) {
        this.customerInfoMapper = customerInfoMapper;
    }

    public CustomerPointLevelMapper getCustomerPointLevelMapper() {
        return this.customerPointLevelMapper;
    }

    @Resource(name="customerPointLevelMapper")
    public void setCustomerPointLevelMapper(CustomerPointLevelMapper customerPointLevelMapper) {
        this.customerPointLevelMapper = customerPointLevelMapper;
    }

    @Override
    public List<CityBean> selectAllCity() {
        return this.customerMapper.selectAllCity();
    }

    @Override
    public List<DistrictBean> selectAllDistrict() {
        return this.customerMapper.selectAllDistrict();
    }

    @Override
    public Object queryOrderByOrderId(Long orderId) {
        return this.customerMapper.queryOrderByOrderId(orderId);
    }

    @Override
    public Customer customer(String customerUserName) {
        return this.customerMapper.customer(customerUserName);
    }

    @Override
    public List<Customer> customerList(String customerUserName) {
        return this.customerMapper.customerList(customerUserName);
    }

    @Override
    @Transactional
    public int updateCus(Customer customer) {
        return this.customerMapper.updateCus(customer);
    }

    @Override
    public CustomerInfo email(Long customerId) {
        return this.customerInfoMapper.email(customerId);
    }

    @Override
    public CustomerInfo mobile(Long customerId) {
        return this.customerInfoMapper.mobile(customerId);
    }

    @Override
    public Customer selectCustomerByUserName(String userName) {
        return this.customerMapper.selectCustomerByUserName(userName);
    }

    @Override
    public List<CustomerStatisticVo> selectCountByTime() {
        return this.customerMapper.selectCountByTime();
    }

    @Override
    public List<CustomerStatisticVo> selectCountByAddress() {
        return this.customerMapper.selectCountByAddress();
    }

    @Override
    public int setCustomer(CustomerAllInfo allinfo) {
        return this.customerMapper.updateByPrimaryKeySelective(allinfo);
    }

    @Override
    public int updatePassword(Map<String, Object> map) {
        return this.customerMapper.updateThirdPassword(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setCustomer(String[] customerId, String isSiteManager) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("isSiteManager", isSiteManager);
            count = this.customerMapper.setCustomerByIds(paramMap);
        }
        finally {
            paramMap = null;
        }
        return count;
    }

    @Override
    public PageBean queryCustomerRank(PageBean pageBean, SelectBean selectBean, String startTime, String endTime) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("startTime", startTime);
        paraMap.put("endTime", endTime);
        paraMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paraMap.put(ENDROWNUM, pageBean.getEndRowNum());
        if (selectBean.getCondition() == null) {
            paraMap.put("condition", "0");
        } else {
            paraMap.put("condition", selectBean.getCondition());
        }
        pageBean.setRows(this.customerMapper.selectAllSize(paraMap));
        pageBean.setList(this.customerMapper.queryCustomerRank(paraMap));
        return pageBean;
    }

    @Override
    public List<Customer> queryCusLevleInfo() {
        return this.customerMapper.queryCusLevleInfo();
    }

    @Override
    public List<Customer> queryCusLevleInfos(List<Customer> list, List<CustomerPointLevel> customerPointLevels) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(customerPointLevels)) {
            return new ArrayList<Customer>();
        }
        Map<String, Integer> map = this.getPointLevelMap(list);
        Map<String, Customer> list1 = this.getPointCustomer(customerPointLevels);
        Customer customer = null;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            customer = list1.get(entry.getKey());
            if (null == customer) continue;
            customer.setLevelCount(Long.parseLong(entry.getValue() + ""));
            customer.setLevelRate(new BigDecimal(entry.getValue()).divide(new BigDecimal(list.size()), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
        }
        return new ArrayList<Customer>(list1.values());
    }

    private Map<String, Customer> getPointCustomer(List<CustomerPointLevel> customerPointLevels) {
        HashMap<String, Customer> map = new HashMap<String, Customer>();
        Customer customer = null;
        for (CustomerPointLevel customerPointLevel : customerPointLevels) {
            customer = new Customer();
            customer.setPointLevelId(customerPointLevel.getPointLevelId());
            customer.setPointLevelName(customerPointLevel.getPointLevelName());
            customer.setLevelCount(0L);
            customer.setLevelRate(new BigDecimal(0));
            map.put(customer.getPointLevelId() + "", customer);
        }
        return map;
    }

    private Map<String, Integer> getPointLevelMap(List<Customer> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer result = 0;
        for (Customer customer : list) {
            if (map.containsKey(customer.getPointLevelId() + "")) {
                Integer n = result = (Integer)map.get(customer.getPointLevelId() + "");
                Integer n2 = result = Integer.valueOf(result + 1);
                map.put(customer.getPointLevelId() + "", result);
                continue;
            }
            map.put(customer.getPointLevelId() + "", 1);
        }
        return map;
    }

    @Override
    public PageBean queryCusAndOrderInfo(PageBean pageBean, Long pointLevelId, String customerNickname) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paraMap.put(ENDROWNUM, pageBean.getEndRowNum());
        paraMap.put("pointLevelId", pointLevelId);
        paraMap.put("customerNickname", customerNickname);
        pageBean.setRows(this.customerMapper.selectCusCount(paraMap));
        pageBean.setList(this.customerMapper.queryCusAndOrderInfo(paraMap));
        return pageBean;
    }

    @Override
    public Map<String, Object> getCustomerCount() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerCount", this.customerMapper.selectCustmerSize(null));
        return map;
    }

    @Override
    public Long checkEmailExist(String email) {
        return this.customerMapper.checkEmailExist(email);
    }

    @Override
    public Long checkMobileExist(String mobile) {
        return this.customerMapper.checkMobileExist(mobile);
    }

    @Override
    public List<Customer> selectNewCustoer() {
        return this.customerMapper.selectCustmerNewLimit();
    }

    @Override
    public int upCusLevel(Map<String, Object> paraMap) {
        return this.customerInfoMapper.upCusLevel(paraMap);
    }

    @Override
    public Integer checkUsernameExitOrNot(Map<String, Object> map) {
        return this.customerMapper.checkUsernameExitOrNot(map);
    }

    @Override
    public List<CustomerAllInfo> selectCustomerAllInfomation() {
        return this.customerMapper.selectCustomerAllInfomation();
    }

    @Override
    public List<CustomerAllInfo> queryListForExportByCustomerIds(Long[] customerIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerIds", customerIds);
        return this.customerMapper.queryListForExportByCustomerIds(map);
    }

    @Override
    public boolean updatePwdInfo(Long customerId, String newpwd) {
        Customer customer = this.customerMapper.queryLoginInfoByCustomerId(customerId);
        String salt = SecurityUtil.getNewPsw();
        String encpwd = SecurityUtil.getStoreLogpwd(customer.getUniqueCode(), newpwd, salt);
        customer.setCustomerPassword(encpwd);
        customer.setSaltVal(salt);
        return this.customerMapper.updatePwdInfo(customer) == 1;
    }

    @Override
    public Customer getCustomerByUsernameType(String username) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (username != null) {
            String nameEmp = username.trim();
            if (nameEmp.indexOf("@") != -1) {
                param.put(UTYPE, "email");
            } else if (Pattern.compile(REGEX).matcher(nameEmp).find()) {
                param.put(UTYPE, "mobile");
            } else {
                param.put(UTYPE, "username");
            }
            param.put("username", username);
            return this.customerMapper.getCustomerByUsernameMap(param);
        }
        return null;
    }

    @Override
    public int selectCustCount(Long customerId) {
        return this.customerMapper.selectCustCount(customerId);
    }

    @Override
    public StreetBean queryStreetBeanById(String streetId) {
        return this.customerMapper.queryStreetBeanById(streetId);
    }

    @Override
    public CustomerAddress selectByCusIdAndAddrId(Long customerId, Long addressId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(CUSTOMERID, customerId);
        map.put("addressId", addressId);
        return this.customerAddressMapper.selectByCusIdAndAddrId(map);
    }

    @Override
    public List<Customer> getCustomerInfo() {
        List<Customer> customers = this.queryCustomer();
        if (CollectionUtils.isEmpty(customers)) {
            return customers;
        }
        this.setCustomerPointLevelIdByPoint(customers);
        return customers;
    }

    private void updateCustomerPointId(List<Customer> customers) {
        for (Customer customer : customers) {
            this.customerMapper.updateCustomerPointId(customer);
        }
    }

    private void setCustomerPointLevelIdByPoint(List<Customer> customers) {
        ForkJoinPool fjpool = new ForkJoinPool();
        fjpool.execute(new CustomerPointLevelTask(0, customers.size(), customers, this.customerPointServiceMapper, this.customerPointServiceMapper.getAllCustomerPointLevelSort()));
        fjpool.shutdown();
        try {
            fjpool.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Customer> queryCustomer() {
        return this.customerMapper.queryCustomerForPoint();
    }

    @Override
    public SendPostMobileCode sendPost(String mobile) {
        String code = SmsUtil.getCode();
        JSONObject modelParam = new JSONObject();
        modelParam.put("code", (Object)code);
        String smsModelType = "1";
        SendPostMobileCode sendPostMobileCode = new SendPostMobileCode(0);
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return sendPostMobileCode;
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId().trim();
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                sendPostMobileCode.setResult(1);
                sendPostMobileCode.setMobile(mobile);
                sendPostMobileCode.setCode(code);
                return sendPostMobileCode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25" + e);
        }
        return sendPostMobileCode;
    }

    @Override
    public int updatePassword(CustomerAllInfo allInfo, Long thirdId) {
        return 0;
    }

    @Override
    @Transactional
    public int addWxBill(List<WxBill> list) {
        int rows = 0;
        try {
            for (WxBill wxBill : list) {
                this.wxBillMapper.addWxBill(wxBill);
            }
            rows = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            rows = -1;
        }
        return rows;
    }

    @Override
    public Long selectCustmerSizeFilterThird(CustomerAllInfo customerAllInfo) {
        return this.customerMapper.selectCustmerSizeFilterThird(customerAllInfo);
    }

    @Override
    public Customer queryCustomerById(Long customerId) {
        Customer customer = this.customerMapper.queryCustomerById(customerId);
        if (null != customer) {
            CustomerAllInfo customerAllInfo = (CustomerAllInfo)customer;
            customerAllInfo.setInfoPointSum(this.customerPointServiceMapper.getCustomerAllPoint(customerId + ""));
            CustomerPointLevel customerPointLevel = this.customerPointServiceMapper.getCustomerPointLevelByPoint(customerAllInfo.getInfoPointSum());
            if (null != customerPointLevel) {
                customerAllInfo.setPointLevelName(customerPointLevel.getPointLevelName());
            }
            return customerAllInfo;
        }
        return customer;
    }

    @Override
    public PageBean queryOrdersForComplain(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerMapper.queryCountForComplain(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryordersforcomplain(paramMap));
        return pb;
    }

    @Override
    public int querySumByCustId(Long customerId) {
        return this.customerMapper.querySumByCustId(customerId);
    }

    @Override
    public int updCustLevel(Long pointLevelId, String pointLevelName, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointLevelId", pointLevelId);
        map.put("pointLevelName", pointLevelName);
        map.put(CUSTOMERID, customerId);
        return this.customerMapper.updCustLevel(map);
    }

    @Override
    public int verifyCheckCode(Long customerId, Long d, String checkCode) {
        GenerateLinkUtils.md5(String.valueOf(new Date().getTime()));
        CustomerAllInfo customer = this.customerMapper.selectByPrimaryKey(customerId);
        if (!"1".equals(customer.getIsEmail())) {
            this.customerPointServiceMapper.addIntegralByType(customerId, "2");
        }
        Customer cust = new Customer();
        cust.setCustomerId(d);
        cust.setIsEmail("1");
        cust.setCustomerId(customerId);
        this.customerMapper.updateByPrimaryKeySelective(cust);
        return 0;
    }

    @Override
    public PageBean queryMyOrders(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerMapper.searchTotalCountO(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryMyOrders(paramMap));
        return pb;
    }

    @Override
    public PageBean queryAllMyOrders(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerMapper.searchTotalCount(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryAllMyOrders(paramMap));
        return pb;
    }

    @Override
    public PageBean queryAllBackMyOrders(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerMapper.searchTotalCountBack(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        List<Object> backOrders = this.customerMapper.queryAllMyBackOrders(paramMap);
        if (null != backOrders && !backOrders.isEmpty()) {
            for (int i = 0; i < backOrders.size(); ++i) {
                String[] strs;
                BackOrder bo = (BackOrder)backOrders.get(i);
                if ("".equals(bo.getBackGoodsIdAndSum()) || (strs = bo.getBackGoodsIdAndSum().split("-")).length <= 0) continue;
                for (int j = 0; j < strs.length; ++j) {
                    OrderGoods og;
                    Long ordergoodsid;
                    String strss = strs[j];
                    Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                    GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                    orderProductVo.setIsPresent("0");
                    if (strss.indexOf(",") != strss.lastIndexOf(",") && null != (ordergoodsid = Long.valueOf(strss.substring(strss.lastIndexOf(",") + 1, strss.length()))) && null != (og = this.orderGoodsMapper.selectOrderGoodsByOGId(ordergoodsid)) && null != og.getIsPresent() && og.getIsPresent().equals("1")) {
                        orderProductVo.setIsPresent("1");
                    }
                    bo.getOrderGoodslistVo().add(orderProductVo);
                }
            }
            pb.setList(backOrders);
        }
        return pb;
    }

    @Override
    public DistrictBean selectDistrictBeanById(Long did) {
        return this.customerMapper.selectDistrictBeanById(did);
    }

    @Override
    public ProvinceBean selectprovinceByPid(Long provinceId) {
        return this.customerMapper.selectprovinceByPid(provinceId);
    }

    @Override
    public SystemsSet getIsBackOrder() {
        return this.customerMapper.getIsBackOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderInfoBean queryOrderByCustIdAndOrderId(Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("orderId", orderId);
            OrderInfoBean orderInfoBean = this.customerMapper.queryOrderByParamMap(paramMap);
            return orderInfoBean;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public Object queryCustomerAddressById(Long orderId) {
        return this.customerMapper.queryCustomerAddressById(orderId);
    }

    @Override
    public Object queryCustomerInfoById(long parseLong) {
        return this.customerMapper.queryCustomerInfoById(parseLong);
    }

    @Override
    public int modifyCustomerInfo(CustomerAllInfo allInfo, String flag) {
        if ("1".equals(flag)) {
            this.customerMapper.modifyCustNickName(allInfo);
        }
        return this.customerMapper.modifyCustomerInfo(allInfo);
    }

    @Override
    public Integer comfirmOfGooods(Long orderId) {
        Integer result = this.customerMapper.comfirmOfGooods(orderId);
        if (result == 1) {
            result = result + this.customerMapper.modifyOrderStatusToSuccess(orderId);
        }
        return result;
    }

    @Override
    public CustomerAllInfo queryCustomerByCustomerId(long parseLong) {
        CustomerAllInfo customerAllInfo = (CustomerAllInfo)this.customerMapper.queryCustomerByCustomerId(parseLong);
        if (null != customerAllInfo) {
            customerAllInfo.setInfoPointSum(this.customerPointServiceMapper.getCustomerAllPoint(parseLong + ""));
        }
        return customerAllInfo;
    }

    @Override
    public int checkCustomerPassword(Long customerId, String password) {
        Customer customer = this.customerMapper.queryLoginInfoByCustomerId(customerId);
        if (customer != null) {
            String encodePwd = SecurityUtil.getStoreLogpwd(customer.getUniqueCode(), password, customer.getSaltVal());
            if (encodePwd.equals(customer.getCustomerPassword())) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int updateByPrimaryKey(CustomerAllInfo allInfo) {
        return this.customerMapper.updateByPrimaryKeySelective(allInfo);
    }

    @Override
    public CustomerAllInfo queryAddressByCustomerId(Long customerId) {
        return this.customerMapper.queryAddressByCustomerId(customerId);
    }

    @Override
    public PageBean queryAddressByCustomerId1(Long customerId, PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long count = this.customerMapper.queryAddressCountByCustomerId(customerId);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        map.put(CUSTOMERID, customerId);
        map.put(STARTROWNUM, pb.getStartRowNum());
        map.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryAddressByCustomerId(map));
        return pb;
    }

    @Override
    public int addCustomerAddress(CustomerAddress address) {
        return this.customerMapper.addCustomerAddress(address);
    }

    @Override
    public int deleteCustAddress(Long addressId) {
        return this.customerMapper.deleteCustAddress(addressId);
    }

    @Override
    public CustomerAddress queryCustAddress(Long addressId) {
        return this.customerMapper.queryCustAddress(addressId);
    }

    @Override
    public int modifyCustAddress(CustomerAddress address) {
        return this.customerMapper.modifyCustAddress(address);
    }

    @Override
    public Map<String, Object> modifyIsDefaultAddress(Long customerId, String addressId) {
        int result = 0;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            int count = this.customerMapper.cancelDefaultAddress(customerId);
            if (count >= 1) {
                CustomerAddress address = this.customerMapper.queryCustAddress(Long.parseLong(addressId));
                if (address != null) {
                    retMap.put("address", address);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("addressId", addressId);
                paramMap.put(CUSTOMERID, customerId);
                this.customerMapper.setDefaultAddress(paramMap);
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("modifyIsDefaultAddress fail,", e);
        }
        retMap.put("retCode", result);
        return retMap;
    }

    @Override
    public PageBean selectAllCustomerPoint(Map<String, Object> paramMap, PageBean pb) {
        pb.setRows(Integer.parseInt(this.customerMapper.queryPointRcCount(paramMap) + ""));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryAllPointRc(paramMap));
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long selectTotalPointByCid(Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, customerId);
            Long l = this.customerMapper.selectTotalPointByCid(paramMap);
            return l;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public PageBean selectAllCustomerFollow(Map<String, Object> paramMap, PageBean pb) {
        pb.setRows(Integer.parseInt(this.customerMapper.queryFollowRcCount(paramMap) + ""));
        paramMap.put(STARTROWNUM, pb.getStartRowNum());
        paramMap.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.customerMapper.queryAllFollowRc(paramMap));
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> selectNotice(Long customerId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("flag", 3);
            resultMap.put("onpayNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 6);
            resultMap.put("onDealNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 4);
            resultMap.put("onReceiptNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 5);
            resultMap.put("onMyNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 0);
            resultMap.put("pendingNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 1);
            resultMap.put("commentNum", this.customerMapper.selectpendingOrderNotice(paramMap));
            resultMap.put("reduceNum", this.customerMapper.selectReducePriceNum(paramMap));
            resultMap.put("goodsArriveNum", this.customerMapper.selectGoodsArriveNum(paramMap));
            Long count = this.customerFollowMapper.selectCustomerFollowCount(customerId);
            resultMap.put("activityGoodsNum", count);
            resultMap.put("noReadNum", this.customerMapper.selectNoReadNum(paramMap));
            resultMap.put("noReadInsideNum", this.insideletter.findInsideCount(customerId));
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            resultMap = null;
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelOrder(Long orderId, String reason) {
        int result = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("orderId", orderId);
            paramMap.put("reason", reason);
            result = this.customerMapper.cancelOrder(paramMap);
            if (result == 1) {
                Order order = this.orderMapper.orderDetail(orderId);
                Long customerId = order.getCustomerId();
                Double orderPrice = order.getOrderPrice().doubleValue();
                if (order.getBusinessId() == 0L && order.getOrderIntegral() != null && order.getOrderIntegral().intValue() != 0) {
                    CustomerPoint cusPoint = new CustomerPoint();
                    cusPoint.setPointDetail("\u8ba2\u5355\u53d6\u6d88\u8fd4\u8fd8\u8ba2\u5355\u4f7f\u7528\u79ef\u5206");
                    cusPoint.setPoint(order.getOrderIntegral().intValue());
                    cusPoint.setPointType("1");
                    cusPoint.setDelFlag("0");
                    cusPoint.setCreateTime(new Date());
                    cusPoint.setCustomerId(order.getCustomerId());
                    this.customerPointMapper.insertSelective(cusPoint);
                    CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
                    int allpoint = info.getInfoPointSum();
                    if (null != order.getOrderIntegral()) {
                        allpoint += order.getOrderIntegral().intValue();
                    }
                    info.setInfoPointSum(allpoint);
                    info.setCustomerId(order.getCustomerId());
                    result = this.customerInfoMapper.updateInfoByCustId(info);
                }
            }
            int n = result;
            return n;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public int delOrder(Long orderId) {
        return this.customerMapper.delOrder(orderId);
    }

    @Override
    public int modifyPem(Long cId, String newStr, String type) {
        CustomerAllInfo cust = new CustomerAllInfo();
        cust.setCustomerId(cId);
        if ("pwd".equals(type)) {
            Customer customer = this.customerMapper.queryLoginInfoByCustomerId(cId);
            String saltVal = SecurityUtil.getNewPsw();
            String uniqueCode = customer.getUniqueCode();
            String encodePwd = SecurityUtil.getStoreLogpwd(uniqueCode, newStr, saltVal);
            Customer loginInfo = new Customer();
            loginInfo.setCustomerId(customer.getCustomerId());
            loginInfo.setUniqueCode(uniqueCode);
            loginInfo.setCustomerPassword(encodePwd);
            loginInfo.setSaltVal(saltVal);
            return this.customerMapper.updatePwdInfo(loginInfo);
        }
        if ("mobile".equals(type)) {
            cust.setIsMobile("1");
            cust.setInfoMobile(newStr);
            CustomerAllInfo custs = this.customerMapper.selectByPrimaryKey(cId);
        } else if ("email".equals(type)) {
            cust.setInfoMobile(newStr);
        }
        this.customerMapper.updateByPrimaryKeySelective(cust);
        return this.customerMapper.modifyCustomerInfo(cust);
    }

    @Override
    public int sendEamil(String email) {
        return 0;
    }

    @Override
    public Map<String, Object> sendSMS(String mobile) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("retCode", "0");
        String code = SmsUtil.getCode();
        String smsModelType = "1";
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return retMap;
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId();
            JSONObject modelParam = new JSONObject();
            modelParam.put("code", (Object)code);
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                retMap.put("mcCode", code);
                retMap.put("userMobile", mobile);
                retMap.put("retCode", "1");
                return retMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25" + e);
        }
        return retMap;
    }

    @Override
    public int getMCode(Long cId, String code, Integer submitCount) {
        if (code == null) {
            return -2;
        }
        Customer customer = this.customerMapper.selectCaptcha(cId);
        if (System.currentTimeMillis() - customer.getAeadTime().getTime() > 1800000L) {
            return -1;
        }
        if (!code.equals(customer.getCaptcha())) {
            if (submitCount != null && submitCount != 0) {
                Integer n = submitCount;
                Integer n2 = submitCount = Integer.valueOf(submitCount + 1);
                if (submitCount > 5) {
                    submitCount = 0;
                    customer.setAeadTime(new Date(customer.getAeadTime().getTime() - 1800000L));
                    customer.setCaptcha(null);
                    customer.setCustomerId(cId);
                    this.customerMapper.updateSmsCaptcha(customer);
                    return -1;
                }
                return 0;
            }
        } else {
            customer.setAeadTime(new Date(customer.getAeadTime().getTime() - 660000L));
            customer.setCaptcha(null);
            customer.setCustomerId(cId);
            this.customerMapper.updateSmsCaptcha(customer);
            CustomerAllInfo cust = this.customerMapper.selectByPrimaryKey(cId);
            return 1;
        }
        submitCount = 1;
        return 0;
    }

    @Override
    public int updateCustInfoByPrimaryKey(CustomerAllInfo user) {
        return this.customerMapper.updateCustInfoByPrimaryKeySelective(user);
    }

    @Override
    public int comfirmofGoods(Long orderId) {
        return this.customerMapper.comfirmOfGooods(orderId);
    }

    @Override
    public Long checkUsernameFlag(String username) {
        return this.customerMapper.checkexistsByCustName(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomerAllInfo selectCustomerByUname(String username) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("username", username);
            CustomerAllInfo customerAllInfo = this.customerSiteService.selectCustomerByUname(paramMap);
            return customerAllInfo;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public int updateFindPwdCode(CustomerAllInfo user) {
        return this.customerMapper.updateSmsCaptcha(user);
    }

    @Override
    public Map validPwdEmail(String checkCode, Long d) {
        HashMap<String, Serializable> respMap = new HashMap<String, Serializable>();
        Customer customer = this.customerMapper.selectCaptcha(d);
        if (customer != null && customer.getPwdCaptcha() != null) {
            if (System.currentTimeMillis() - customer.getPwdAeadTime().getTime() > 0x6DDD00L) {
                respMap.put("result", Integer.valueOf(-1));
                return respMap;
            }
            if (checkCode.equals(customer.getPwdCaptcha())) {
                CustomerAllInfo cust = this.selectCustomerByUname(customer.getCustomerUsername());
                respMap.put("user", cust);
                respMap.put("uId", cust.getCustomerId());
                customer.setPwdAeadTime(new Date(customer.getPwdAeadTime().getTime() - 0x6DDD00L));
                customer.setPwdCaptcha("");
                customer.setCustomerId(d);
                this.customerMapper.updateSmsCaptcha(customer);
                respMap.put("cFlag", Integer.valueOf(1));
                respMap.put("result", Integer.valueOf(1));
                return respMap;
            }
            respMap.put("result", Integer.valueOf(-2));
            return respMap;
        }
        respMap.put("result", Integer.valueOf(-2));
        return respMap;
    }

    @Override
    public Long checkexistsByIdAndCode(Long customerId, String orderCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, customerId);
        paramMap.put("orderCode", orderCode);
        return this.customerMapper.checkexistsByIdAndCode(paramMap);
    }

    @Override
    public List<CustomerPointLevel> queryPointLevel() {
        return this.customerMapper.queryPointLevel();
    }

    @Override
    public boolean isCustomerAddressNumLegal(Long customerId) {
        boolean flag = false;
        Long addsNum = this.customerMapper.queryAddressCountByCustomerId(customerId);
        if (addsNum.intValue() < 10) {
            flag = true;
        }
        return flag;
    }

    @Override
    public CustomerAddress selectByAddrIdAndCusId(Long customerId, Long addressId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CUSTOMERID, customerId);
        map.put("addressId", addressId);
        return this.customerMapper.selectByAddrIdAndCusId(map);
    }

    @Override
    public List<CustomerAddress> selectAddressByCustomerId(Long customerId) {
        return this.customerMapper.selectAddressByCustomerId(customerId);
    }

    @Override
    public List<OrderInfoBean> selectOrderByCustomerId(Long customerId) {
        return this.customerMapper.selectOrderByCustomerId(customerId);
    }
}

