/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.findpwd.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.findpwd.service.FindPwdService;
import com.qianjiang.utils.SecurityUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="findPwdService")
public class FindPwdServiceImpl
implements FindPwdService {
    private static final String UTYPE = "uType";
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;

    @Override
    public Object forGetPwd(Map param, String code, String mobile, String newPassword) {
        String sessonCode = param.get("UpdatePassCode").toString();
        String userMobile = param.get("UpdatePassMobile").toString();
        if (StringUtils.isEmpty((String)sessonCode) || StringUtils.isEmpty((String)userMobile)) {
            return 0;
        }
        if (!code.equals(sessonCode) || !mobile.equals(userMobile)) {
            return 0;
        }
        HashMap<String, Object> paramMap = null;
        String nameEmp = mobile.trim();
        paramMap = new HashMap<String, Object>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", mobile);
        Customer customerN = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
        if (customerN == null) {
            return 2;
        }
        CustomerAllInfo allInfo = new CustomerAllInfo();
        allInfo.setInfoMobile((String)param.get("userMobilex"));
        String salt = SecurityUtil.getNewPsw();
        String newpwd = SecurityUtil.getStoreLogpwd(customerN.getUniqueCode(), newPassword, salt);
        allInfo.setCustomerPassword(newpwd);
        allInfo.setSaltVal(salt);
        allInfo.setCustomerId(customerN.getCustomerId());
        this.customerMapper.updatePwdInfo(allInfo);
        return "1";
    }

    @Override
    public int checkCustomerExists(String username) throws UnsupportedEncodingException {
        HashMap<String, Object> paramMap = null;
        String nameEmp = username.trim();
        paramMap = new HashMap<String, Object>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", username);
        Customer customerN = this.customerMapper.selectCustomerByNamePwdAndType(paramMap);
        if (customerN != null) {
            return 1;
        }
        return 2;
    }
}

