/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.coupon.service.impl;

import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.bean.CouponRe;
import com.qianjiang.coupon.dao.CouponNoMapper;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="CouponNoService")
public class CouponNoServiceImpl
implements CouponNoService {
    private static final String COUPONID = "couponId";
    @Resource(name="CouponNoMapper")
    private CouponNoMapper couponNoMapper;
    @Resource(name="CouponService")
    private CouponService couponService;

    @Override
    public List<CouponNo> selectNoByCouponId(Long couponId) {
        return this.couponNoMapper.selectNoByCouponId(couponId);
    }

    @Override
    public int updateCodeIsUse(String codeNo, String orderCode) {
        CouponNo cn = new CouponNo();
        cn.setCodeGetTime(new Date());
        cn.setCodeUseOrderId(orderCode);
        cn.setCodeNo(codeNo);
        cn.setCodeGetTime(new Date());
        return this.couponNoMapper.updateCodeIsUse(cn);
    }

    @Override
    public CouponNo selectNoByCouponIdByStatus(Long couponNo) {
        return this.couponNoMapper.selectNoByCouponIdByStatus(couponNo);
    }

    @Override
    public PageBean selectList(PageBean pb, Long couponId, CouponNo couponNo) {
        Map paramMap = MapUtil.getParamsMap((Object)couponNo);
        try {
            paramMap.put(COUPONID, couponId);
            paramMap.put("start", pb.getStartRowNum());
            paramMap.put("end", pb.getEndRowNum());
            pb.setRows(this.couponNoMapper.selectNoCountByCouponId(paramMap));
            paramMap.put("start", pb.getStartRowNum());
            paramMap.put("number", pb.getEndRowNum());
            pb.setList(this.couponNoMapper.selectNoListByCouponId(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public int changeCouponGetAndStatus(Long codeId) {
        return this.couponNoMapper.changeCouponGetAndStatus(codeId);
    }

    @Override
    public CouponRe exportCouponCodeNo(Long couponId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(COUPONID, couponId);
        List<CouponNo> couponNos = this.couponNoMapper.newSelectCouponList(param);
        Coupon coupon = this.couponService.searchCouponById(couponId);
        CouponRe couponRe = new CouponRe();
        couponRe.setCoupon(coupon);
        couponRe.setCouponNoList(couponNos);
        return couponRe;
    }

    @Override
    public int getCouponGetNoByCouponId(Long couponId) {
        return this.couponNoMapper.getCouponGetNoByCouponId(couponId);
    }

    @Override
    public int updateCouponCustomer(Long codeId, Long cId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("codeId", codeId);
        param.put("customerId", cId);
        return this.couponNoMapper.updateCouponCustomer(param);
    }

    @Override
    public int selectReadyGet(Long couponId, Long cId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(COUPONID, couponId);
        param.put("customerId", cId);
        return this.couponNoMapper.selectReadyGet(param);
    }

    @Override
    public Long queryUsedCountByCouponId(Long couponId) {
        return this.couponNoMapper.queryUsedCountByCouponId(couponId);
    }

    @Override
    public int selectCountAllByCouponId(Long couponId) {
        return this.couponNoMapper.selectCountAllByCouponId(couponId);
    }

    @Override
    public int selectCouponNoByStatus(Long couponId) {
        return this.couponNoMapper.selectCouponNoByStatus(couponId);
    }

    @Override
    public List<CouponNo> selectCouponList(Long couponId, CouponNo couponNo) {
        Map paramMap = MapUtil.getParamsMap((Object)couponNo);
        paramMap.put(COUPONID, couponId);
        return this.couponNoMapper.newSelectCouponList(paramMap);
    }

    @Override
    public int selectCouponByCode(String couponCode, Long cId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeNo", couponCode);
        CouponNo couponNo = this.couponNoMapper.selectCouponNo(map);
        map.clear();
        if (couponNo == null) {
            return 1;
        }
        Coupon coupon = this.couponService.searchCouponById(couponNo.getCouponId());
        int countAll = this.couponNoMapper.selectCountAllByCouponId(couponNo.getCouponId());
        map.put(COUPONID, couponNo.getCouponId());
        map.put("customerId", cId);
        Long yilingPersonCount = this.couponNoMapper.queryUsedCountByCouponIdNew(map);
        Long yilingCount = this.couponNoMapper.queryUsedCountByCouponId(couponNo.getCouponId());
        Date d = new Date();
        if ("0".equals(couponNo.getCodeStatus()) && couponNo.getCustomerId() == null && countAll - yilingCount.intValue() > 0 && coupon.getCouponStartTime().before(d) && coupon.getCouponEndTime().after(d) && yilingPersonCount < (long)coupon.getCouponGetNo().intValue()) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("codeId", couponNo.getCodeId());
            param.put("customerId", cId);
            this.couponNoMapper.updateCouponCustomer(param);
            return 2;
        }
        return 3;
    }

    @Override
    public CouponNo selectCouponNoByCode(String code) {
        return this.couponNoMapper.selectCouponNoByCode(code);
    }
}

