/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.service.impl;

import com.qianjiang.gift.bean.Gift;
import com.qianjiang.gift.bean.GiftCate;
import com.qianjiang.gift.bean.GiftSearchVo;
import com.qianjiang.gift.dao.GiftCateMapper;
import com.qianjiang.gift.dao.GiftMapper;
import com.qianjiang.gift.service.GiftShopSiteService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GiftShopSiteService")
public class GiftShopSiteServiceImpl
implements GiftShopSiteService {
    @Resource(name="GiftCateMapper")
    GiftCateMapper giftCateMapper;
    @Resource(name="GiftMapper")
    GiftMapper giftMapper;

    @Override
    public List<GiftCate> searchGiftCate() {
        Map paramMap = MapUtil.getParamsMap((Object)new GiftCate());
        paramMap.put("start", null);
        paramMap.put("number", null);
        List<GiftCate> parentList = this.giftCateMapper.searchGiftParentCateList(paramMap);
        List<GiftCate> allCateList = this.giftCateMapper.searchGiftCateList();
        ArrayList<GiftCate> cateVoList = new ArrayList<GiftCate>();
        GiftCate cate = null;
        GiftCate cateVo = null;
        if (parentList != null && !parentList.isEmpty()) {
            for (int i = 0; i < parentList.size(); ++i) {
                cate = parentList.get(i);
                cateVo = new GiftCate();
                cateVo.setGiftCateId(cate.getGiftCateId());
                cateVo.setGiftCateName(cate.getGiftCateName());
                cateVo.setGiftParentId(cate.getGiftParentId());
                cateVo.setGiftCateRemark(cate.getGiftCateRemark());
                cateVo.setCateVos(this.calcCateVo(cateVo.getGiftCateId(), allCateList));
                cateVoList.add(cateVo);
            }
        }
        return cateVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCate> calcCateVo(Long parentId, List<GiftCate> allCateList) {
        ArrayList<GiftCate> cateVoList = new ArrayList<GiftCate>();
        GiftCate cateVo = null;
        List<GiftCate> allSonCate = null;
        GiftCate cate = null;
        try {
            for (int i = 0; i < allCateList.size(); ++i) {
                if (!parentId.equals(allCateList.get(i).getGiftParentId())) continue;
                cateVo = new GiftCate();
                cate = allCateList.get(i);
                cateVo.setGiftCateId(cate.getGiftCateId());
                cateVo.setGiftCateName(cate.getGiftCateName());
                cateVo.setGiftParentId(cate.getGiftParentId());
                cateVo.setGiftCateRemark(cate.getGiftCateRemark());
                allSonCate = this.calcCateVo(cate.getGiftCateId(), allCateList);
                cateVo.setCateVos(allSonCate);
                cateVoList.add(cateVo);
            }
            ArrayList<GiftCate> arrayList = cateVoList;
            return arrayList;
        }
        finally {
            cateVoList = null;
            cateVo = null;
            allSonCate = null;
            cate = null;
        }
    }

    @Override
    public PageBean searchGiftList(GiftSearchVo gift, PageBean pb) {
        gift.setDelFlag("0");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("giftCateId", gift.getGiftCateId());
        paramMap.put("startIntegral", gift.getStartIntegral());
        paramMap.put("endIntegral", gift.getEndIntegral());
        int rows = this.giftMapper.searchGiftListCount(paramMap);
        if (rows > 0) {
            pb.setRows(rows);
        } else {
            pb.setRows(0);
        }
        pb.setObjectBean((Object)gift);
        paramMap.put("start", pb.getStartRowNum());
        paramMap.put("number", pb.getEndRowNum());
        pb.setList(this.giftMapper.searchGiftList(paramMap));
        return pb;
    }

    @Override
    public Gift selectByGiftId(Long giftId) {
        return this.giftMapper.selectGiftDetailById(giftId);
    }

    @Override
    public GiftCate selectByParentId(Long cateId) {
        if (cateId != null) {
            GiftCate parentCate = this.giftCateMapper.searchGiftCateById(cateId);
            List<GiftCate> allCate = this.giftCateMapper.searchGiftCateList();
            parentCate.setCateVos(this.calcCateVo(parentCate.getGiftCateId(), allCate));
            return parentCate;
        }
        return null;
    }

    @Override
    public GiftCate selectByCateId(Long cateId) {
        if (cateId != null) {
            GiftCate cate = this.giftCateMapper.searchGiftCateById(cateId);
            if (cate.getGiftParentId() != null) {
                cate.setParentCate(this.giftCateMapper.searchGiftCateById(cate.getGiftParentId()));
            }
            return cate;
        }
        return null;
    }

    @Override
    public String selectSonCateId(Long cateId) {
        String url = this.giftCateMapper.querysCateIdBypCateId(cateId) + "-" + cateId.toString();
        return url;
    }
}

