/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.service.impl;

import com.qianjiang.gift.bean.GiftCate;
import com.qianjiang.gift.dao.GiftCateMapper;
import com.qianjiang.gift.service.GiftCateService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GiftCateService")
public class GiftCateServiceImpl
implements GiftCateService {
    private GiftCateMapper giftCateMapper;

    @Override
    public List<GiftCate> searchGiftCateList(Long giftCateId) {
        return this.giftCateMapper.searchGiftCateList(giftCateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchGiftCateList(GiftCate giftCate, PageBean pageBean) {
        giftCate.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)giftCate);
        pageBean.setRows(this.giftCateMapper.searchGiftCateListCount(paramMap));
        Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
        no = no == 0 ? 1 : no;
        if (pageBean.getPageNo() >= no) {
            pageBean.setPageNo(no.intValue());
            pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            pageBean.setObjectBean((Object)giftCate);
        }
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        try {
            List<GiftCate> parentList = this.giftCateMapper.searchGiftParentCateList(paramMap);
            List<GiftCate> allCateList = this.giftCateMapper.searchGiftCateList();
            ArrayList<GiftCate> cateVoList = new ArrayList<GiftCate>();
            GiftCate cate = null;
            GiftCate cateVo = null;
            try {
                for (int i = 0; i < parentList.size(); ++i) {
                    cate = parentList.get(i);
                    cateVo = new GiftCate();
                    cateVo.setGiftCateId(cate.getGiftCateId());
                    cateVo.setGiftCateName(cate.getGiftCateName());
                    cateVo.setGiftParentId(cate.getGiftParentId());
                    cateVo.setGiftCateRemark(cate.getGiftCateRemark());
                    cateVo.setCateVos(this.calcCateVo(cateVo.getGiftCateId(), allCateList));
                    cateVoList.add(cateVo);
                }
                pageBean.setList(cateVoList);
                PageBean pageBean2 = pageBean;
                cateVoList = null;
                parentList = null;
                allCateList = null;
                cate = null;
                cateVo = null;
                return pageBean2;
            }
            catch (Throwable throwable) {
                cateVoList = null;
                parentList = null;
                allCateList = null;
                cate = null;
                cateVo = null;
                throw throwable;
            }
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> searchGiftCateListNoPage(GiftCate giftCate) {
        giftCate.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)giftCate);
        paramMap.put("start", null);
        paramMap.put("number", null);
        try {
            List<GiftCate> parentList = this.giftCateMapper.searchGiftParentCateList(paramMap);
            List<GiftCate> allCateList = this.giftCateMapper.searchGiftCateList();
            ArrayList<Object> cateVoList = new ArrayList<Object>();
            GiftCate cate = null;
            GiftCate cateVo = null;
            try {
                for (int i = 0; i < parentList.size(); ++i) {
                    cate = parentList.get(i);
                    cateVo = new GiftCate();
                    cateVo.setGiftCateId(cate.getGiftCateId());
                    cateVo.setGiftCateName(cate.getGiftCateName());
                    cateVo.setGiftParentId(cate.getGiftParentId());
                    cateVo.setGiftCateRemark(cate.getGiftCateRemark());
                    cateVo.setCateVos(this.calcCateVo(cateVo.getGiftCateId(), allCateList));
                    cateVoList.add(cateVo);
                }
                ArrayList<Object> arrayList = cateVoList;
                cateVoList = null;
                parentList = null;
                allCateList = null;
                cate = null;
                cateVo = null;
                return arrayList;
            }
            catch (Throwable throwable) {
                cateVoList = null;
                parentList = null;
                allCateList = null;
                cate = null;
                cateVo = null;
                throw throwable;
            }
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCate> calcCateVo(Long parentId, List<GiftCate> allCateList) {
        ArrayList<GiftCate> cateVoList = new ArrayList<GiftCate>();
        GiftCate cateVo = null;
        List<GiftCate> allSonCate = null;
        GiftCate cate = null;
        try {
            for (int i = 0; i < allCateList.size(); ++i) {
                if (!parentId.equals(allCateList.get(i).getGiftParentId())) continue;
                cateVo = new GiftCate();
                cate = allCateList.get(i);
                cateVo.setGiftCateId(cate.getGiftCateId());
                cateVo.setGiftCateName(cate.getGiftCateName());
                cateVo.setGiftParentId(cate.getGiftParentId());
                cateVo.setGiftCateRemark(cate.getGiftCateRemark());
                allSonCate = this.calcCateVo(cate.getGiftCateId(), allCateList);
                cateVo.setCateVos(allSonCate);
                cateVoList.add(cateVo);
            }
            ArrayList<GiftCate> arrayList = cateVoList;
            return arrayList;
        }
        finally {
            cateVoList = null;
            cateVo = null;
            allSonCate = null;
            cate = null;
        }
    }

    @Override
    public GiftCate searchGiftCateById(Long giftCateId) {
        return this.giftCateMapper.searchGiftCateById(giftCateId);
    }

    @Override
    public int addGiftCate(GiftCate giftCate) {
        if (giftCate.getGiftParentId() == 0L) {
            giftCate.setGiftCateRemark("1");
        } else {
            String grade = this.searchGiftCateById(giftCate.getGiftParentId()).getGiftCateRemark();
            int grade1 = Integer.parseInt(grade) + 1;
            giftCate.setGiftCateRemark(String.valueOf(grade1));
        }
        giftCate.setModifyTime(new Date());
        giftCate.setCreateTime(new Date());
        giftCate.setDelFlag("0");
        return this.giftCateMapper.addGiftCate(giftCate);
    }

    @Override
    public int updateGiftCate(GiftCate giftCate) {
        if (giftCate.getGiftParentId() == 0L) {
            giftCate.setGiftCateRemark("1");
        } else {
            String grade = this.searchGiftCateById(giftCate.getGiftParentId()).getGiftCateRemark();
            int grade1 = Integer.parseInt(grade) + 1;
            giftCate.setGiftCateRemark(String.valueOf(grade1));
        }
        giftCate.setModifyTime(new Date());
        giftCate.setDelFlag("0");
        return this.giftCateMapper.updateGiftCate(giftCate);
    }

    @Override
    public int delGiftCate(Long giftCateId) {
        return this.giftCateMapper.delGiftCate(giftCateId);
    }

    @Override
    public int delAllGiftCate(Long[] giftCateId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long cateId : giftCateId) {
            list.add(cateId);
        }
        return this.giftCateMapper.delAllGiftCate(list);
    }

    @Override
    public List<GiftCate> searchGiftCateList() {
        return this.giftCateMapper.searchGiftCateList();
    }

    @Override
    public List<GiftCate> selectGiftListUseSelect() {
        return this.giftCateMapper.selectGiftListUseSelect();
    }

    @Override
    public boolean checkDelGiftCate(Long cateId) {
        return this.giftCateMapper.querySonCateByParentId(cateId) <= 0;
    }

    public GiftCateMapper getGiftCateMapper() {
        return this.giftCateMapper;
    }

    @Resource(name="GiftCateMapper")
    public void setGiftCateMapper(GiftCateMapper giftCateMapper) {
        this.giftCateMapper = giftCateMapper;
    }
}

