/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.service.impl;

import com.qianjiang.third.goods.bean.ThirdCate;
import com.qianjiang.third.goods.dao.ThirdCateMapper;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.third.goods.vo.ThirdCateVo;
import com.qianjiang.util.SelectBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ThirdCateService1")
public class ThirdCateServiceImpl
implements ThirdCateService {
    private static final String CATID = "catId";
    @Resource(name="ThirdCateMapper1")
    private ThirdCateMapper thirdCateMapper;

    @Override
    @Transactional
    public int insertThirdCate(ThirdCate thirdCate, String username) {
        thirdCate.setCatCreateName(username);
        thirdCate.setCatIsShow("1");
        thirdCate.setCatDelflag("0");
        ThirdCateVo resultCate = this.thirdCateMapper.selectByPrimaryKey(thirdCate.getCatParentId());
        if (null != resultCate) {
            thirdCate.setCatGrade(resultCate.getCatGrade() + 1);
        } else {
            thirdCate.setCatGrade(1);
        }
        return this.thirdCateMapper.insertSelective(thirdCate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delThirdCate(Long catId, String username) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(CATID, catId);
            map.put("delName", username);
            int n = this.thirdCateMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delThirdCateNew(Long catId, String username, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(CATID, catId);
            map.put("delName", username);
            map.put("thirdId", thirdId);
            int n = this.thirdCateMapper.deleteByPrimaryKeyNew(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelThirdCate(Long[] catIds, String username) {
        Integer count = 0;
        try {
            if (ArrayUtils.isNotEmpty((Object[])catIds)) {
                for (int i = 0; i < catIds.length; ++i) {
                    count = count + this.delThirdCate(catIds[i], username);
                }
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
        }
    }

    @Override
    @Transactional
    public int updateThirdCate(ThirdCate thirdCate, String username) {
        if (null == thirdCate || null == thirdCate.getCatParentId()) {
            return 0;
        }
        thirdCate.setCatModifiedName(username);
        if (thirdCate.getCatParentId().equals(0L)) {
            thirdCate.setCatGrade(1);
        } else {
            thirdCate.setCatGrade(this.thirdCateMapper.selectByPrimaryKey(thirdCate.getCatParentId()).getCatGrade() + 1);
        }
        return this.thirdCateMapper.updateByPrimaryKeySelective(thirdCate);
    }

    @Override
    public ThirdCateVo queryThirdCateById(Long catId) {
        return this.thirdCateMapper.selectByPrimaryKey(catId);
    }

    @Override
    public List<ThirdCate> queryAllCate(Long thirdId) {
        return this.thirdCateMapper.queryAllCate(thirdId);
    }

    @Override
    public boolean checkDelWithCateId(Long cateId) {
        return this.thirdCateMapper.querySonCountByParentId(cateId) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThirdCate queyCateByCateName(String cateName, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("cateName", cateName);
            map.put("thirdId", thirdId);
            ThirdCate thirdCate = this.thirdCateMapper.queryCateByCateName(map);
            return thirdCate;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllCalcThirdCate(SelectBean selectBean, Long thirdId) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", selectBean.getCondition().trim());
        map.put("searchText", selectBean.getSearchText().trim());
        map.put("thirdId", thirdId);
        ArrayList<Object> cateVoList = new ArrayList<Object>();
        List<ThirdCateVo> parentList = this.thirdCateMapper.queryAllThirdCate(map);
        List<ThirdCateVo> allCateList = this.thirdCateMapper.queryAllCateForList(thirdId);
        ThirdCateVo cate = null;
        ThirdCateVo cateVo = null;
        try {
            if (null != parentList && !parentList.isEmpty()) {
                for (int i = 0; i < parentList.size(); ++i) {
                    cate = parentList.get(i);
                    cateVo = new ThirdCateVo();
                    cateVo.setCatGrade(cate.getCatGrade());
                    cateVo.setCatId(cate.getCatId());
                    cateVo.setCatImg(cate.getCatImg());
                    cateVo.setCatName(cate.getCatName());
                    cateVo.setCatParentId(cate.getCatParentId());
                    cateVo.setCatSort(cate.getCatSort());
                    cateVo.setThirdId(cate.getThirdId());
                    cateVo.setThirdName(cate.getThirdName());
                    cateVo.setCatCreateTime(cate.getCatCreateTime());
                    cateVo.setCateVos(this.calcCateVo(cateVo.getCatId(), allCateList));
                    cateVoList.add(cateVo);
                }
            }
            ArrayList<Object> arrayList = cateVoList;
            return arrayList;
        }
        finally {
            cateVoList = null;
            parentList = null;
            allCateList = null;
            cate = null;
            cateVo = null;
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ThirdCateVo> calcCateVo(Long parentId, List<ThirdCateVo> allCateList) {
        ArrayList<ThirdCateVo> cateVoList = new ArrayList<ThirdCateVo>();
        ThirdCateVo cateVo = null;
        ThirdCateVo cate = null;
        try {
            for (int i = 0; i < allCateList.size(); ++i) {
                if (!parentId.equals(allCateList.get(i).getCatParentId())) continue;
                cate = allCateList.get(i);
                cateVo = new ThirdCateVo();
                cateVo.setCatGrade(cate.getCatGrade());
                cateVo.setCatId(cate.getCatId());
                cateVo.setCatImg(cate.getCatImg());
                cateVo.setCatName(cate.getCatName());
                cateVo.setCatParentId(cate.getCatParentId());
                cateVo.setCatSort(cate.getCatSort());
                cateVo.setThirdId(cate.getThirdId());
                cateVo.setThirdName(cate.getThirdName());
                cateVo.setCatCreateTime(cate.getCatCreateTime());
                cateVo.setCateVos(this.calcCateVo(cateVo.getCatId(), allCateList));
                cateVoList.add(cateVo);
            }
            ArrayList<ThirdCateVo> arrayList = cateVoList;
            return arrayList;
        }
        finally {
            cateVoList = null;
            cateVo = null;
            cate = null;
        }
    }

    @Override
    public List<ThirdCateVo> queryAllThirdCate(Map<String, Object> map) {
        return this.thirdCateMapper.queryAllThirdCate(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ThirdCate> getThirdCateByParentId(Long catId, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(CATID, catId);
            map.put("thirdId", thirdId);
            List<ThirdCate> list = this.thirdCateMapper.queryThirdCateByParentId(map);
            return list;
        }
        finally {
            map = null;
        }
    }

    @Override
    public List<ThirdCate> getThirdCateByParentIdtwo(Long thirdId) {
        return this.thirdCateMapper.queryThirdCateByParentIdtwo(thirdId);
    }

    @Override
    public List<ThirdCate> getThirdCateByCateNameAndGrade(String catName, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catName", catName);
        map.put("thirdId", thirdId);
        List<ThirdCate> thirdCateList = new ArrayList<ThirdCate>();
        for (int i = 3; i >= 1; --i) {
            map.put("grade", i);
            thirdCateList = this.thirdCateMapper.queryThirdCateByCatNameAndGrade(map);
            if (null != thirdCateList && !thirdCateList.isEmpty()) break;
        }
        return thirdCateList;
    }

    @Override
    public List<ThirdCate> queryThirdSonCateByCateIdAndName(Long catGrade, String thirdCateName, Long thirdId, Long catParentId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cateParentId", catParentId);
        paramMap.put("catGrade", catGrade);
        paramMap.put("cateName", thirdCateName);
        paramMap.put("thirdId", thirdId);
        return this.thirdCateMapper.querySonCatByParm(paramMap);
    }

    @Override
    public List<ThirdCate> queryThirdAllCate(long thirdId) {
        return this.thirdCateMapper.queryAllCate(thirdId);
    }

    @Override
    public ThirdCate queryThirdCateByEntity(ThirdCate queryCate) {
        ThirdCate cate = null;
        if (null != queryCate) {
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("cateName", queryCate.getCatName());
            queryMap.put("thirdId", queryCate.getThirdId());
            cate = this.thirdCateMapper.queryCateByCateName(queryMap);
        }
        return cate;
    }
}

