/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.login.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.dao.CustomerAddressMapper1;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.third.login.bean.IpRecord;
import com.qianjiang.third.login.bean.ReLogin;
import com.qianjiang.third.login.mapper.IpRecordMapper;
import com.qianjiang.third.login.service.LoginService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.mapper.StoreInfoMapper;
import com.qianjiang.utils.SecurityUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="loginServiceThird")
public class LoginServiceImpl
implements LoginService {
    private static final String USERNAME = "username";
    private CustomerMapper customerMapper;
    @Resource(name="customerAddressMapperM")
    private CustomerAddressMapper1 addressMapper;
    private CustomerPointServiceMapper customerPointServiceMapper;
    private IpRecordMapper ipRecordMapper;
    private StoreInfoMapper sotreInfoMapper;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @Override
    public int checkThirdAuthority(String username) {
        return this.sotreInfoMapper.checkThirdAuthority(username);
    }

    private boolean isSupplier(Long customerId) {
        StoreInfo sinfo = this.sotreInfoMapper.selectByCustomerId(customerId);
        return sinfo != null && "1".equals(sinfo.getIsSupplier());
    }

    @Override
    public ReLogin checkCustomerExists(String ip, String username, String password) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String nameEmp = username.trim();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put("uType", "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put("uType", "mobile");
        } else {
            paramMap.put("uType", USERNAME);
        }
        paramMap.put(USERNAME, username);
        Customer customer = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
        ReLogin reLogin = new ReLogin();
        if (customer != null) {
            String encodePwd = SecurityUtil.getStoreLogpwd((String)customer.getUniqueCode(), (String)password, (String)customer.getSaltVal());
            if (!encodePwd.equals(customer.getCustomerPassword())) {
                reLogin.setCode(0);
                return reLogin;
            }
            if (this.isSupplier(customer.getCustomerId())) {
                reLogin.setCode(6);
                return reLogin;
            }
            if ("1".equals(customer.getIsFlag())) {
                reLogin.setCode(7);
                return reLogin;
            }
            customer.setCustomerPassword(null);
            customer.setLoginTime(new Date());
            customer.setLoginIp(ip);
            this.customerMapper.updateCustomerLoginTime(customer);
            reLogin.setCustomerId(customer.getCustomerId());
            reLogin.setCustomer(customer);
            reLogin.setBsetDomain(this.basicSetService.findBasicSet().getBsetDomain());
            this.removeErrCount(ip);
            if (customer.getThirdId() != null) {
                StoreInfo storeInfo = this.sotreInfoMapper.selectByCustomerId(customer.getCustomerId());
                if (storeInfo != null) {
                    if ("0".equals(storeInfo.getCheckStatus()) && "0".equals(storeInfo.getIsSubmit()) && null != storeInfo.getRefuseContent()) {
                        reLogin.setCode(10);
                        return reLogin;
                    }
                    if ("0".equals(storeInfo.getCheckStatus()) && ("1".equals(storeInfo.getIsSubmit()) || storeInfo.getRefuseContent() != null && storeInfo.getRefuseContent().length() != 0)) {
                        reLogin.setCode(4);
                        return reLogin;
                    }
                    if ("1".equals(storeInfo.getCheckStatus()) && "1".equals(storeInfo.getIsSubmit())) {
                        storeInfo.setRefuseContent("");
                        this.sotreInfoMapper.updateByPrimaryKeySelective(storeInfo);
                        reLogin.setThirdId(customer.getThirdId());
                        reLogin.setStoreName(storeInfo.getStoreName());
                        reLogin.setIsStoreIndex(storeInfo.getIsStoreIndex());
                        reLogin.setCode(1);
                        return reLogin;
                    }
                    if ("1".equals(storeInfo.getCheckStatus())) {
                        reLogin.setCode(5);
                        return reLogin;
                    }
                } else if ("0".equals(customer.getIsSeller())) {
                    reLogin.setCode(3);
                    return reLogin;
                }
            }
            if ("0".equals(customer.getIsSeller())) {
                reLogin.setCode(3);
                return reLogin;
            }
            reLogin.setThirdId(customer.getThirdId());
            reLogin.setCode(1);
            return reLogin;
        }
        this.updateErrCount(ip);
        reLogin.setCode(2);
        return reLogin;
    }

    private boolean checkPassword(Customer customer, String pwd) {
        if (customer != null) {
            String userCode = customer.getUniqueCode();
            String salt = customer.getSaltVal();
            String encpwd = SecurityUtil.getStoreLogpwd((String)userCode, (String)pwd, (String)salt);
            return customer.getCustomerPassword().equals(encpwd);
        }
        return false;
    }

    private void removeErrCount(String ip) {
        IpRecord ipRecord = this.ipRecordMapper.selectByIp(ip);
        if (ipRecord != null) {
            ipRecord.setErrCount(0L);
            this.ipRecordMapper.updateByPrimaryKeySelective(ipRecord);
        }
    }

    @Override
    public Long getErrCount(String ip) {
        IpRecord ipRecord = this.ipRecordMapper.selectByIp(ip);
        return ipRecord != null ? ipRecord.getErrCount() : 0L;
    }

    private void addErrIp(String ip) {
        IpRecord record = new IpRecord();
        record.setCaptTime(new Date());
        record.setEndCaptTime(new Date(System.currentTimeMillis() + 1800000L));
        record.setIp(ip);
        record.setDelFlag("0");
        record.setErrCount(1L);
        this.ipRecordMapper.insertSelective(record);
    }

    private void updateErrCount(String ip) {
        IpRecord ipRecord = this.ipRecordMapper.selectByIp(ip);
        if (ipRecord == null) {
            this.addErrIp(ip);
            return;
        }
        ipRecord.setErrCount(ipRecord.getErrCount() + 1L);
        this.ipRecordMapper.updateByPrimaryKeySelective(ipRecord);
    }

    public CustomerMapper getCustomerMapper() {
        return this.customerMapper;
    }

    @Resource(name="customerMapper")
    public void setCustomerMapper(CustomerMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }

    public IpRecordMapper getIpRecordMapper() {
        return this.ipRecordMapper;
    }

    @Resource(name="ipRecordMapper")
    public void setIpRecordMapper(IpRecordMapper ipRecordMapper) {
        this.ipRecordMapper = ipRecordMapper;
    }

    public StoreInfoMapper getSotreInfoMapper() {
        return this.sotreInfoMapper;
    }

    @Resource(name="sotreInfoMapper")
    public void setSotreInfoMapper(StoreInfoMapper sotreInfoMapper) {
        this.sotreInfoMapper = sotreInfoMapper;
    }

    private boolean isCustomerExists(String username) {
        return 0L != this.customerMapper.checkexistsByCustName(username);
    }

    private Customer getCustomerByUserNameAndPassword(String username, String password) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put(USERNAME, username);
        paramMap.put("password", password);
        return this.customerMapper.selectCustomerByNamePwd(paramMap);
    }

    @Override
    public void updateCustomerLoginTime(Customer customer) {
        this.customerMapper.updateCustomerLoginTime(customer);
    }
}

