/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.order.service.impl;

import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.third.order.mapper.ThirdOrderMapper;
import com.qianjiang.third.order.service.ThirdOrderService;
import com.qianjiang.util.DaysOrderUtil;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ThirdOrderService")
public class ThirdOrderServiceImpl
implements ThirdOrderService {
    private static final String THIRDID = "thirdId";
    private ThirdOrderMapper mapper;
    @Resource(name="OrderService")
    private OrderService bossOrderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchOrderList(PageBean pb, Order order) {
        Map paramMap = MapUtil.getParamsMap((Object)order);
        try {
            pb.setRows(this.mapper.searchThridOrderCountRow(paramMap));
            paramMap.put("start", pb.getStartRowNum());
            paramMap.put("number", pb.getEndRowNum());
            List<Object> orders = this.mapper.searchThridOrderList(paramMap);
            pb.setList(orders);
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public PageBean searchOrderListByOrderCargo(PageBean pb, Order order) {
        if (order.getOrderCargoStatus() == null) {
            order.setOrderCargoStatus("0");
        }
        order.setOrderStatus("1");
        return this.searchOrderList(pb, order);
    }

    @Override
    public void updateThirdOrderByParam(Order order) {
        this.mapper.updateThirdOrderByParam(order);
    }

    @Override
    public void updateThirdOrder(Order order) {
        this.mapper.updateThirdOrder(order);
    }

    @Override
    public Order searcharOrderByParam(Long orderId) {
        return this.mapper.searcharOrderByParam(orderId);
    }

    @Override
    public void updateThirdOrderByParams(Long[] orderId) {
        for (int i = 0; i < orderId.length; ++i) {
            Order order = new Order();
            order.setOrderId(orderId[i]);
            order.setOrderStatus("4");
            this.mapper.updateThirdOrderByParam(order);
        }
    }

    public ThirdOrderMapper getMapper() {
        return this.mapper;
    }

    @Resource(name="ThridOrderMapper")
    public void setMapper(ThirdOrderMapper mapper) {
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryOrderCountByStaAndThirdId(String status, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("status", status);
            map.put(THIRDID, thirdId);
            int n = this.mapper.queryOrderCountBySta(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DaysOrderUtil querySalesOrderCountByFlag(int flag, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (0 == flag) {
                DaysOrderUtil daysOrderUtil = this.mapper.queryYestSalesOrderCount(map);
                return daysOrderUtil;
            }
            DaysOrderUtil daysOrderUtil = this.mapper.queryTodaySalesOrderCount(map);
            return daysOrderUtil;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> orderPicking(Long[] orderId, String customerUsername, Long thirdid) {
        Map map;
        String pickingName;
        try {
            pickingName = customerUsername;
            Map map2 = map = this.bossOrderService.queryByPincking(orderId, thirdid, pickingName, null);
            return map2;
        }
        finally {
            pickingName = null;
            map = null;
        }
    }

    @Override
    public int goOrderPicking(Long[] orderId, Long thirdid) {
        return this.bossOrderService.updateOrderCargoStatusByThirdOrderIds(orderId, "1", thirdid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryOrderCountByStaAndCustomerId(String status, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("status", status);
            map.put("customerId", customerId);
            int n = this.mapper.queryCustomerOrderCountBySta(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchBuyOrderList(PageBean pb, Order order) {
        Map paramMap = MapUtil.getParamsMap((Object)order);
        try {
            pb.setRows(this.mapper.searchPuyThridOrderCountRow(paramMap));
            paramMap.put("start", pb.getStartRowNum());
            paramMap.put("number", pb.getEndRowNum());
            pb.setList(this.mapper.searchPuyThridOrderList(paramMap));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public List<OrderGoods> queryOrderGoods(Long orderId) {
        return this.mapper.selectOrderGoodsList(orderId);
    }

    @Override
    public int modifyGoodsBackPrice(BigDecimal goodsBackPrice, Long orderId, Long goodsInfoId) {
        HashMap<String, Object> pa = new HashMap<String, Object>();
        pa.put("goodsBackPrice", goodsBackPrice);
        pa.put("goodsInfoId", goodsInfoId);
        pa.put("orderId", orderId);
        return this.mapper.modifyGoodsBackPrice(pa);
    }
}

