/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.third.goods.dao.ThirdGoodsMapper;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.goods.util.ThirdGoodsSearchBean;
import com.qianjiang.third.goods.vo.SalesProductVo;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ThirdGoodsService")
public class ThirdGoodsServiceImpl
implements ThirdGoodsService {
    private static final String GOODSADDED = "goodsAdded";
    private static final String CONDITION = "condition";
    private static final String SEARCHTEXT = "searchText";
    private static final String GOODSNAME = "goodsName";
    private static final String GOODSNO = "goodsNo";
    private static final String LOWGOODSPRICE = "lowGoodsPrice";
    private static final String HIGHGOODSPRICE = "highGoodsPrice";
    private static final String LOWCREATETIME = "lowCreateTime";
    private static final String HIGHCREATETIME = "highCreateTime";
    private static final String NPCATEID = "npCateId";
    private static final String THIRDCATEID = "thirdCateId";
    private static final String THIRDID = "thirdId";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private ThirdGoodsMapper thirdGoodsMapper;
    @Resource(name="sellerService")
    private SellerService sellerService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryThirdGoodsList(PageBean pb, Long thirdId, ThirdGoodsSearchBean searchBean, Long goodsAddedSta) {
        Long goodsAddedStaNew = goodsAddedSta;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == goodsAddedStaNew) {
            goodsAddedStaNew = 1L;
        }
        map.put(GOODSADDED, goodsAddedStaNew.toString());
        if (null != searchBean) {
            if (null != searchBean.getCondition()) {
                map.put(CONDITION, searchBean.getCondition());
                map.put(SEARCHTEXT, searchBean.getSearchText());
            } else {
                map.put(GOODSNAME, searchBean.getGoodsName());
                map.put(GOODSNO, searchBean.getGoodsNo());
                map.put(LOWGOODSPRICE, searchBean.getLowPrice());
                map.put(HIGHGOODSPRICE, searchBean.getHighPrice());
                map.put(LOWCREATETIME, searchBean.getLowCreateTime());
                map.put(HIGHCREATETIME, searchBean.getHighCreateTime());
                map.put(NPCATEID, searchBean.getNpCateId());
                map.put(THIRDCATEID, searchBean.getThirdCateId());
            }
        }
        try {
            map.put(THIRDID, thirdId);
            pb.setRows(this.thirdGoodsMapper.queryThirdGoodsCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.thirdGoodsMapper.queryThirdGoodsList(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryThirdGoodsListByFlag(PageBean pb, Long thirdId, ThirdGoodsSearchBean searchBean, Long goodsAddedSta, Long flag) {
        Long goodsAddedStaNew = goodsAddedSta;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == goodsAddedStaNew) {
            goodsAddedStaNew = 1L;
        }
        map.put(GOODSADDED, goodsAddedStaNew.toString());
        map.put("flag", flag.toString());
        if (null != searchBean) {
            if (null != searchBean.getCondition()) {
                map.put(CONDITION, searchBean.getCondition());
                map.put(SEARCHTEXT, searchBean.getSearchText());
            } else {
                if (searchBean.getHighPrice() != null && searchBean.getLowPrice() != null && searchBean.getHighPrice().compareTo(searchBean.getLowPrice()) < 0) {
                    BigDecimal lowPrice = searchBean.getLowPrice();
                    BigDecimal highPrice = searchBean.getHighPrice();
                    searchBean.setHighPrice(lowPrice);
                    searchBean.setLowPrice(highPrice);
                    map.put("highPrice", searchBean.getHighPrice());
                    map.put("lowPrice", searchBean.getLowPrice());
                }
                map.put(GOODSNAME, searchBean.getGoodsName());
                map.put(GOODSNO, searchBean.getGoodsNo());
                map.put(LOWGOODSPRICE, searchBean.getLowPrice());
                map.put(HIGHGOODSPRICE, searchBean.getHighPrice());
                map.put(LOWCREATETIME, searchBean.getLowCreateTime());
                map.put(HIGHCREATETIME, searchBean.getHighCreateTime());
                map.put(NPCATEID, searchBean.getNpCateId());
                map.put(THIRDCATEID, searchBean.getThirdCateId());
            }
        }
        try {
            map.put(THIRDID, thirdId);
            pb.setRows(this.thirdGoodsMapper.queryThirdGoodsCountByFlag(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.thirdGoodsMapper.queryThirdGoodsListByFlag(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SalesProductVo> queryTopSalesGoods(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(THIRDID, thirdId);
            List<SalesProductVo> list = this.thirdGoodsMapper.queryTopSalesByThirdId(map);
            return list;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryThirdGoodsCopyList(PageBean pb, Long thirdId, ThirdGoodsSearchBean searchBean, Long goodsAddedSta) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long goodsAddedStaNew = goodsAddedSta;
        if (null == goodsAddedStaNew) {
            goodsAddedStaNew = 1L;
        }
        map.put(GOODSADDED, goodsAddedStaNew.toString());
        if (null != searchBean) {
            if (null != searchBean.getCondition()) {
                map.put(CONDITION, searchBean.getCondition());
                map.put(SEARCHTEXT, searchBean.getSearchText());
            } else {
                map.put(GOODSNAME, searchBean.getGoodsName());
                map.put(GOODSNO, searchBean.getGoodsNo());
                map.put(LOWGOODSPRICE, searchBean.getLowPrice());
                map.put(HIGHGOODSPRICE, searchBean.getHighPrice());
                map.put(LOWCREATETIME, searchBean.getLowCreateTime());
                map.put(HIGHCREATETIME, searchBean.getHighCreateTime());
                map.put(NPCATEID, searchBean.getNpCateId());
                map.put(THIRDCATEID, searchBean.getThirdCateId());
            }
        }
        try {
            map.put(THIRDID, thirdId);
            pb.setRows(this.thirdGoodsMapper.queryThirdGoodsCopyCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.thirdGoodsMapper.queryThirdGoodsCopyList(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    @Override
    @Transactional
    public int copyByGoodsIds(Long thirdId, Long[] goodsIds, Customer cust, String ip, String name, Long loginUserId) {
        StoreInfo info = this.sellerService.selectByStoreId(thirdId);
        for (int i = 0; i < goodsIds.length; ++i) {
            this.goodsService.copyGoods(cust, ip, name, loginUserId, goodsIds[i], thirdId, info.getStoreName());
        }
        return 0;
    }

    @Override
    public String bsetUrl() {
        return this.thirdGoodsMapper.bsetUrl();
    }

    public ThirdGoodsMapper getThirdGoodsMapper() {
        return this.thirdGoodsMapper;
    }

    @Resource(name="ThirdGoodsMapper")
    public void setThirdGoodsMapper(ThirdGoodsMapper thirdGoodsMapper) {
        this.thirdGoodsMapper = thirdGoodsMapper;
    }
}

