/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.alipaymini.service;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.alipaymini.AlipayMiniConstants;
import com.yqbsoft.laser.service.ext.channel.alipaymini.util.DecryptUtil;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelOauthBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ChannelOauthServiceImpl
extends ChannelOauthBaseService {
    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        if (StringUtils.isBlank((String)channelRequest.getCmFchannelApi().getAppapiCode())) {
            throw new ApiException("cmc.ChannelOauthBaseService.send.apicode", channelRequest.getCmFchannelApi().getFchannelApiCode());
        }
        String private_key = channelRequest.getRequestData().get("private_key").toString();
        String alipay_public_key = channelRequest.getRequestData().get("alipay_public_key").toString();
        String charset = channelRequest.getRequestData().get("charset").toString();
        String sign_type = channelRequest.getRequestData().get("sign_type").toString();
        String format = channelRequest.getRequestData().get("format").toString();
        String aap_id = channelRequest.getRequestData().get("app_id").toString();
        String accessToken = SupDisUtil.getRemot((String)aap_id);
        if (StringUtils.isBlank((String)accessToken)) {
            throw new ApiException("cmc.ChannelOauthBaseService.send.accessToken", aap_id);
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(channelRequest.getCmFchannelApi().getFchannelApiUrl(), aap_id, private_key, format, charset, alipay_public_key, sign_type);
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        AlipayUserInfoShareResponse response = null;
        try {
            response = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)request, accessToken);
        }
        catch (AlipayApiException e) {
            this.logger.error("cmc.ChannelOauthBaseService.retrunParam.e", (Throwable)e);
            return null;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (response.isSuccess()) {
            resultMap.put("gender", response.getGender());
            resultMap.put("nick_name", response.getNickName());
            resultMap.put("province", response.getProvince());
            resultMap.put("city", response.getCity());
            resultMap.put("avatar", response.getAvatar());
            resultMap.put("phone", response.getPhone());
        } else {
            this.logger.error("cmc.ChannelOauthBaseService.retrunParam.error", (Object)response.getMsg());
        }
        return resultMap;
    }

    private Map<String, Object> resultMap(int code, boolean success, String dataObj, String openid, String unionid, String register, String session_key) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", code);
        resultMap.put("success", success);
        resultMap.put("dataObj", dataObj);
        resultMap.put("openid", openid);
        resultMap.put("unionid", unionid);
        resultMap.put("register", register);
        resultMap.put("session_key", session_key);
        return resultMap;
    }

    public String getFchannelCode() {
        return AlipayMiniConstants.channelCode;
    }

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> param) {
        if (null == channelRequest || MapUtil.isEmpty(param)) {
            return channelRequest;
        }
        return channelRequest;
    }

    private Object login(String url, Map<String, Object> requestData, Map<String, Object> param) {
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.put("appid", (String)requestData.get("appid"));
        invoiceMap.put("secret", (String)requestData.get("secret"));
        invoiceMap.put("js_code", (String)param.get("js_code"));
        invoiceMap.put("grant_type", (String)requestData.get("grant_type"));
        String result = "";
        try {
            result = WebUtils.doGet((String)url, invoiceMap, null);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("cmc.ChannelOauthBaseService.login:result", (Object)(result + "+(result\u4e3a\u7a7a)"));
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error("cmc.ChannelOauthBaseService.login:result", (Object)result, (Throwable)e);
            return null;
        }
        this.logger.error("cmc.ChannelOauthBaseService.login:result", (Object)result);
        String unionId = "";
        String openid = "";
        if (StringUtils.isBlank((String)result)) {
            return this.resultMap(-1, false, result, openid, unionId, (String)requestData.get("register"), null);
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        if (MapUtil.isNotEmpty((Map)jsonToMap) && null != jsonToMap.get("openid")) {
            openid = (String)jsonToMap.get("openid");
            if (null != jsonToMap.get("unionid")) {
                unionId = jsonToMap.get("unionid").toString();
            }
            if (StringUtils.isBlank((String)unionId)) {
                unionId = this.getUnionId(param, jsonToMap);
            }
            return this.resultMap(1, true, result, openid, unionId, (String)requestData.get("register"), jsonToMap.get("session_key").toString());
        }
        return this.resultMap(-1, false, result, openid, unionId, (String)requestData.get("register"), null);
    }

    private String getUnionId(Map<String, Object> param, Map<String, Object> jsonToMap) {
        if (null == jsonToMap.get("session_key") || null == param.get("encryptedData") || null == param.get("iv").toString()) {
            return null;
        }
        return this.json2object(jsonToMap.get("session_key").toString(), param.get("encryptedData").toString(), param.get("iv").toString());
    }

    public String json2object(String sessionKey, String encryptData, String iv) {
        String unionId = "";
        JSONObject temp = new JSONObject();
        try {
            temp = JSONObject.json2object((String)new String(DecryptUtil.pkcs7decode(DecryptUtil.aseDecrypt(encryptData, sessionKey, iv))));
            unionId = temp.getString("unionId");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.logger.error("cmc.ChannelOauthBaseService.getUnionId:temp", (Object)JsonUtil.buildNormalBinder().toJson((Object)temp));
        return unionId;
    }
}

