/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.alipaywap.util;

import com.yqbsoft.laser.service.ext.channel.alipaywap.sign.RSA;
import com.yqbsoft.laser.service.ext.channel.alipaywap.util.AlipayConfig;
import com.yqbsoft.laser.service.ext.channel.alipaywap.util.AlipayCore;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class AlipayNotify {
    protected static final SupperLogUtil logger = new SupperLogUtil(AlipayNotify.class);
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    public static boolean verify(Map<String, String> params, String public_key, String partner) {
        String responseTxt = "true";
        if (params.get("notify_id") != null && null != partner && !"".equals(partner)) {
            String notify_id = params.get("notify_id");
            responseTxt = AlipayNotify.verifyResponse(notify_id, partner);
        }
        logger.info("AlipayNotify.verify.responseTxt", (Object)responseTxt);
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        boolean isSign = AlipayNotify.getSignVeryfy(params, sign, public_key);
        logger.info("AlipayNotify.verify.isSign", (Object)isSign);
        return isSign && responseTxt.equals("true");
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String sign, String public_key) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = AlipayCore.createLinkString(sParaNew);
        logger.info("AlipayNotify.getSignVeryfy.preSignStr", (Object)preSignStr);
        logger.info("AlipayNotify.getSignVeryfy.sign", (Object)sign);
        logger.info("AlipayNotify.getSignVeryfy.public_key", (Object)public_key);
        boolean isSign = false;
        if (AlipayConfig.sign_type.equals("RSA")) {
            isSign = RSA.verify(preSignStr, sign, public_key, AlipayConfig.input_charset);
        }
        return isSign;
    }

    private static String verifyResponse(String notify_id, String partner) {
        String veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notify_id;
        return AlipayNotify.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }
}

