/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.pm.service;

import com.yqbsoft.laser.service.ext.channel.be.BeConstants;
import com.yqbsoft.laser.service.ext.channel.be.service.HttpRequestUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.PmPromotionDiscountDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisPmBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisPmServiceImpl
extends DisPmBaseService {
    private String SYS_CODE = "be.DisPmServiceImpl";

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        Integer timestamp = Integer.valueOf(DisPmServiceImpl.create_timestamp());
        sendParam.put("timestamp", timestamp);
        sendParam.put("encrypt", "");
        sendParam.put("version", Integer.valueOf(configMap.get("version")));
        HashMap<String, Object> body = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        if ("cmc.disPm.saveOpenPlatActivityBasicInfo".equals(channelApiCode)) {
            String shoppingId = this.getShoppingId(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)param.get("app_poi_code"));
            if (StringUtils.isBlank((String)shoppingId)) {
                this.logger.error(this.SYS_CODE + ".buildComOrderParam.shoppingId.null", (Object)("app_poi_code======" + param.get("app_poi_code")));
            }
            body.put("shop_id", shoppingId);
            PmPromotionDomain pmPromotionDomain = (PmPromotionDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)param.get("pmPromotionDomain"), PmPromotionDomain.class);
            body.put("activity_name", pmPromotionDomain.getPromotionName());
            body.put("activity_type", 8);
            body.put("child_type", 0);
            body.put("start_time", pmPromotionDomain.getPromotionBegintime().getTime() / 1000L);
            body.put("end_time", pmPromotionDomain.getPromotionEndtime().getTime() / 1000L);
            body.put("open_time", "00:00");
            body.put("close_time", "23:59");
            body.put("weekday", "0,1,2,3,4,5,6");
            ArrayList ruleList = new ArrayList();
            for (PmPromotionDiscountDomain pmPromotionDiscountDomain : pmPromotionDomain.getPmPromotionDiscountList()) {
                HashMap<String, BigDecimal> ruleMap = new HashMap<String, BigDecimal>();
                ruleMap.put("sale", pmPromotionDiscountDomain.getDiscAmount());
                ruleMap.put("accords", pmPromotionDiscountDomain.getDiscStart());
                ruleList.add(ruleMap);
            }
            body.put("rule", JsonUtil.buildNonDefaultBinder().toJson(ruleList));
        }
        sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        this.logger.error(this.SYS_CODE + ".buildComOrderParam == param = del ======================", (Object)(sendParam + " : " + param));
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            this.logger.error(this.SYS_CODE + ".sendComOrder");
            return "ERROR";
        }
        String url = configMap.get("host");
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = HttpRequestUtil.sendPost(url, sendhttpParam);
            this.logger.error(this.SYS_CODE + "sendComOrder: ", (Object)json);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map beOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)beOrderMap)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.beOrderMap", (Object)("===" + json + "====" + sendhttpParam.toString() + "====" + channelApiCode + "===" + url));
            return null;
        }
        if ("cmc.disPm.saveOpenPlatActivityBasicInfo".equals(channelApiCode)) {
            // empty if block
        }
        return null;
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    protected String getChannelCode() {
        return BeConstants.channelCode;
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

