/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.store.service;

import com.github.pagehelper.util.StringUtil;
import com.yqbsoft.laser.service.ext.channel.be.BeConstants;
import com.yqbsoft.laser.service.ext.channel.be.service.HttpRequestUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfoChannelDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfoQua;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisStoreBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStoreServiceImpl
extends DisStoreBaseService {
    private String SYS_CODE = "be.DisStoreServiceImpl";
    String ctype = "application/json;charset=utf-8";

    protected String getChannelCode() {
        return BeConstants.channelCode;
    }

    private List<Map<String, Object>> buildDeliveryRegion() {
        return null;
    }

    public Map<String, Object> buildStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)param.get("umUserinfo");
        if (null == umUserinfo) {
            return null;
        }
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        HashMap<String, String> businessime = new HashMap<String, String>();
        HashMap<String, String> deliveryRegion = new HashMap<String, String>();
        List umUserinfoChannelDomains = umUserinfo.getUmUserinfoChannelDomainList();
        int i = 0;
        sendParam.put("timeError", "\u8425\u4e1a\u65f6\u95f4\u8bbe\u7f6e\u6709\u8bef\uff01");
        if (ListUtil.isNotEmpty((Collection)umUserinfoChannelDomains)) {
            String openTime = "";
            for (UmUserinfoChannelDomain ucd : umUserinfoChannelDomains) {
                if (!disChannel.getChannelCode().equals(ucd.getChannelCode())) continue;
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("transportFree")) {
                    deliveryRegion.put("delivery_fee", ucd.getUserinfoChannelVaule());
                }
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("packingFee")) {
                    body.put("package_box_price", ucd.getUserinfoChannelVaule());
                }
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelOpenTime")) {
                    if (StringUtils.isBlank((String)ucd.getUserinfoChannelVaule())) continue;
                    businessime.put("start", ucd.getUserinfoChannelVaule());
                    ++i;
                }
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelCloseTime")) {
                    if (StringUtils.isBlank((String)ucd.getUserinfoChannelVaule())) continue;
                    businessime.put("end", ucd.getUserinfoChannelVaule());
                    ++i;
                }
                if (i < 2) continue;
                sendParam.remove("timeError");
            }
        }
        if (i == 0) {
            List userinfoQuas = umUserinfo.getUmUserinfoQuaList();
            String time = "";
            if (ListUtil.isNotEmpty((Collection)userinfoQuas)) {
                for (UmUserinfoQua userinfoQua : userinfoQuas) {
                    if (StringUtil.isNotEmpty((String)userinfoQua.getUserinfoQuaKey()) && userinfoQua.getUserinfoQuaKey().equals("storeOpenTime")) {
                        if (StringUtils.isBlank((String)userinfoQua.getUserinfoQuaVaule())) continue;
                        businessime.put("start", userinfoQua.getUserinfoQuaVaule());
                        ++i;
                    }
                    if (!StringUtil.isNotEmpty((String)userinfoQua.getUserinfoQuaKey()) || !userinfoQua.getUserinfoQuaKey().equals("storeCloseTime") || StringUtils.isBlank((String)userinfoQua.getUserinfoQuaVaule())) continue;
                    businessime.put("end", userinfoQua.getUserinfoQuaVaule());
                    ++i;
                }
            }
            if (i >= 2) {
                sendParam.remove("timeError");
            }
        }
        body.put("shop_logo", umUserinfo.getUserinfoCertUrl());
        body.put("name", umUserinfo.getUserinfoCompname());
        body.put("phone", umUserinfo.getUserinfoPhone());
        body.put("ivr_phone", umUserinfo.getUserinfoPhone());
        body.put("service_phone", umUserinfo.getUserinfoPhone());
        ArrayList<HashMap<String, String>> timeList = new ArrayList<HashMap<String, String>>();
        timeList.add(businessime);
        body.put("business_time", timeList);
        sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        return sendParam;
    }

    public Map<String, Object> buildStoreStartParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public Map<String, Object> buildStoreEndParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    private Map<String, Object> buildStoreComParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel || MapUtil.isEmpty(param)) {
            return null;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        return sendParam;
    }

    public String sendStoreStartParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreEndParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    private String sendStoreComParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        if (StringUtils.isNotBlank((String)((String)sendhttpParam.get("timeError")))) {
            return (String)sendhttpParam.get("timeError");
        }
        String url = configMap.get(BeConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        String json = HttpRequestUtil.sendPost(url, sendhttpParam);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, Object> beResult = this.make(json);
        if (null == beResult) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.beResult.null", (Object)(json + "=" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return json;
        }
        if (null != beResult.get("error") && !beResult.get("error").equals("success")) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.Error", (Object)(json + "=" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)beResult.get("error");
        }
        return "SUCCESS";
    }

    public UmUserinfo sendGetStore(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return null;
        }
        String url = configMap.get(BeConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        String json = HttpRequestUtil.sendPost(url, sendhttpParam);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        Map<String, Object> beResult = this.make(json);
        if (null == beResult) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.beResult.null", (Object)(json + "=" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        if (null == beResult.get("data") || MapUtil.isEmpty((Map)((Map)beResult.get("data")))) {
            return null;
        }
        Map data = (Map)beResult.get("data");
        UmUserinfo umUserinfo = new UmUserinfo();
        umUserinfo.setCompanyAddress((String)data.get("address"));
        umUserinfo.setUserinfoMap((String)data.get("longitude"));
        umUserinfo.setUserinfoCompname((String)data.get("name"));
        umUserinfo.setUserinfoPhone((String)data.get("phone"));
        umUserinfo.setDataState(Integer.valueOf(0));
        return umUserinfo;
    }

    private Map<String, Object> make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        Map data = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        Map beResult = (Map)data.get("body");
        if (null == beResult) {
            return null;
        }
        return beResult;
    }

    public Map<String, Object> buildGetStoreParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }
}

