/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.boc.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.boc.util.BocPayConfig;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        this.logger.error("cmc.ChannelSignServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelSignServiceImpl.sign", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        if (null != exmap) {
            String spbill_create_ip;
            String openId = (String)exmap.get("openId");
            if (StringUtils.isNotBlank((String)openId)) {
                channelRequest.getRequestData().put("subOpenid", openId);
            }
            if (StringUtils.isNotBlank((String)(spbill_create_ip = (String)exmap.get("client_ip")))) {
                channelRequest.getRequestData().put("spbillCreateIp", spbill_create_ip);
            }
        }
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        String appname = (String)channelRequest.getConfigMap().get(BocPayConfig.appname);
        channelRequest.getRequestData().put("body", appname.concat("-") + cmChannelClear.getBusinessOrderno());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String orderTime = sdf.format(cmChannelClear.getGmtCreate());
        channelRequest.getRequestData().put("orderTime", orderTime);
        String merchantNo = (String)channelRequest.getRequestData().get(BocPayConfig.merchantNo);
        String orderNo = "";
        if (StringUtils.isNotBlank((String)merchantNo)) {
            orderNo = merchantNo.substring(merchantNo.length() - 6) + cmChannelClear.getBusinessOrderno();
            channelRequest.getRequestData().put("orderNo", orderNo);
        }
        String curCode = (String)channelRequest.getRequestData().get(BocPayConfig.curCode);
        String orderAmount = cmChannelClear.getOrderAmount().setScale(2, 4).toString();
        channelRequest.getRequestData().put("orderAmount", orderAmount);
        if (StringUtils.isBlank((String)orderNo) || StringUtils.isBlank((String)orderTime) || StringUtils.isBlank((String)curCode) || StringUtils.isBlank((String)orderAmount) || StringUtils.isBlank((String)merchantNo)) {
            this.logger.error("cmc.ChannelSignServiceImpl.sign", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null");
        }
        String signatureStr = orderNo.concat("|") + orderTime.concat("|") + curCode.concat("|") + orderAmount.concat("|") + merchantNo;
        byte[] data = signatureStr.getBytes();
        String signature = "";
        String keyStorePath = (String)channelRequest.getConfigMap().get(BocPayConfig.keyStorePath);
        String keyStorePassword = (String)channelRequest.getConfigMap().get(BocPayConfig.keyStorePassword);
        String keyPassword = (String)channelRequest.getConfigMap().get(BocPayConfig.keyPassword);
        if (StringUtils.isBlank((String)keyStorePath) || StringUtils.isBlank((String)keyStorePassword) || StringUtils.isBlank((String)keyPassword)) {
            this.logger.error("cmc.ChannelSignServiceImpl.signature", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.signature");
        }
        channelRequest.getRequestData().put("signData", signature);
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("subAppid", configMap.get("sub_appid"));
        }
        if (configMap != null && configMap.containsKey("merchantNo")) {
            requestMap.put("merchantNo", configMap.get("merchantNo"));
        }
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        return this.buildApiCallParam(bankRequest);
    }
}

