/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.ceb.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.ceb.util.ceb.SignUtil;
import com.yqbsoft.laser.service.ext.channel.ceb.util.ceb.SignUtils;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";
    private static Logger log = LoggerFactory.getLogger(ChannelSignServiceImpl.class);

    public void sign(ChannelRequest channelRequest) {
        String mch_id = (String)channelRequest.getConfigMap().get("mch_id");
        String req_url = (String)channelRequest.getConfigMap().get("req_url");
        String notify_url = (String)channelRequest.getConfigMap().get("notify_url");
        String mchPrivateKey = (String)channelRequest.getConfigMap().get("mchPrivateKey");
        String platPublicKey = (String)channelRequest.getConfigMap().get("platPublicKey");
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelSignServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        this.logger.error("cmc.ChannelSignServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        try {
            Map<String, String> params = SignUtils.paraFilter(channelRequest.getRequestData());
            StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
            SignUtils.buildPayParams(buf, params, false);
            String preStr = buf.toString();
            String sign_type = params.get("sign_type");
            String signature = SignUtil.getSign(sign_type, preStr, mchPrivateKey);
            channelRequest.getRequestData().put("sign", signature);
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelSignServiceImpl.signature.tool", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.signature.tool", (Throwable)e);
        }
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        log.error("Sign verifySign...Start", (Object)bankRequest);
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        log.error("Sign error...Start");
        String mchPrivateKey = (String)bankRequest.getConfigMap().get("mchPrivateKey");
        String platPublicKey = (String)bankRequest.getConfigMap().get("platPublicKey");
        log.error("Sign verify...Start");
        Map res = bankRequest.getRequestData();
        if (!ChannelSignServiceImpl.verify(res, platPublicKey)) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
        }
        log.error("Sign verify...end");
        bankRequest.setRequestData(res);
        log.error("Sign error...end");
        log.error("Sign...bankRequest:{}", (Object)bankRequest);
        return this.buildApiCallParam(bankRequest);
    }

    public static boolean verify(Map<String, String> resultMap, String platPublicKey) {
        log.error("Sign-------verify...start");
        String reSign = resultMap.get("sign");
        String sign_type = resultMap.get("sign_type");
        try {
            return !resultMap.containsKey("sign") || SignUtil.verifySign(reSign, sign_type, resultMap, platPublicKey);
        }
        catch (Exception e) {
            log.error("Sign error...", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }
}

