/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.ceb.util.ceb;

import com.yqbsoft.laser.service.ext.channel.ceb.util.ceb.RSAUtil;
import com.yqbsoft.laser.service.ext.channel.ceb.util.ceb.SignUtils;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static Logger log = LoggerFactory.getLogger(SignUtil.class);
    public static String signTypeRsa1256 = "RSA_1_256";

    public static String getSign(String signType, String preStr, String mchPrivateKey) {
        log.error("=============signType:{}", (Object)signType);
        log.error("=============preStr:{}", (Object)preStr);
        log.error("=============mchPrivateKey:{}", (Object)mchPrivateKey);
        if (signTypeRsa1256.equals(signType)) {
            try {
                return SignUtil.sign(preStr, signTypeRsa1256, mchPrivateKey);
            }
            catch (Exception e1) {
                log.error("getSign\u5f02\u5e38\uff1a", (Throwable)e1);
            }
        } else {
            log.error("===\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u3002\u3002\u3002\uff0c,{}", (Object)signType);
        }
        return null;
    }

    public static boolean verifySign(String sign, String signType, Map<String, String> resultMap, String platPublicKey) throws Exception {
        if ("RSA_1_256".equals(signType)) {
            Map<String, String> Reparams = SignUtils.paraFilter(resultMap);
            StringBuilder Rebuf = new StringBuilder((Reparams.size() + 1) * 10);
            SignUtils.buildPayParams(Rebuf, Reparams, false);
            String RepreStr = Rebuf.toString();
            if (SignUtil.verifySign(RepreStr, sign, "RSA_1_256", platPublicKey)) {
                return true;
            }
        } else if ("MD5".equals(signType)) {
            log.error("===\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u3002\u3002\u3002\uff0c,{}", (Object)signType);
        }
        return false;
    }

    public static boolean verifySign(String preStr, String sign, String signType, String platPublicKey) throws Exception {
        RSAUtil.SignatureSuite suite = null;
        if ("RSA_1_1".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA1;
        } else if ("RSA_1_256".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA256;
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f");
        }
        boolean result = RSAUtil.verifySign(suite, preStr.getBytes("UTF8"), Base64.decodeBase64((byte[])sign.getBytes("UTF8")), platPublicKey);
        return result;
    }

    public static String sign(String preStr, String signType, String mchPrivateKey) throws Exception {
        RSAUtil.SignatureSuite suite = null;
        if ("RSA_1_1".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA1;
        } else if ("RSA_1_256".equals(signType)) {
            suite = RSAUtil.SignatureSuite.SHA256;
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f");
        }
        byte[] signBuf = RSAUtil.sign(suite, preStr.getBytes("UTF8"), mchPrivateKey);
        return new String(Base64.encodeBase64((byte[])signBuf), "UTF8");
    }
}

