/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.ext.channel.discom.api.DisGoodsService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDictionaryDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ImageBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisGoodsBaseService
extends DisBaseServiceImpl
implements DisGoodsService {
    private String SYS_CODE = "cmc.DisGoodsBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        if (channelApiCode.equals("cmc.disGoods.saveSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.delSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClassSort")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        return this.buildComGoodsParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        if (channelApiCode.equals("cmc.disGoods.saveSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.delSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClassSort")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        return this.sendComSaveGoods(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    protected void saveClassDictionary(DisChannel disChannel, String memberCode, String goodsClassCode, String thirdClassCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)goodsClassCode) || StringUtils.isBlank((String)thirdClassCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        DisDictionaryDomain disDictionaryDomain = new DisDictionaryDomain();
        disDictionaryDomain.setChannelCode(disChannel.getChannelCode());
        disDictionaryDomain.setTenantCode(tenantCode);
        disDictionaryDomain.setDictionaryType("RsGoodsClass");
        disDictionaryDomain.setDictionaryName("\u5206\u7c7bID");
        disDictionaryDomain.setDictionaryGoods("goodsClassCode");
        disDictionaryDomain.setDictionaryValue(goodsClassCode);
        disDictionaryDomain.setDictionaryDisgoods("categoryId");
        disDictionaryDomain.setDictionaryBvalue(thirdClassCode);
        String apiCode = "dis.dictionary.saveDictionary";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disDictionaryDomain", JsonUtil.buildNormalBinder().toJson((Object)disDictionaryDomain));
        this.internalInvoke(apiCode, paramMap);
    }

    protected String getCategoryId(String tenantCode, String channelCode, String goodsClassCode) {
        String categoryId = this.getDictionaryValue(tenantCode, channelCode, "RsGoodsClass", "goodsClassCode", goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            this.logger.error(this.SYS_CODE + ".getCategoryId.categoryId", (Object)(channelCode + "-" + goodsClassCode + "-" + tenantCode));
            return null;
        }
        return categoryId;
    }

    public abstract Map<String, Object> buildComGoodsClassParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract String sendComSaveGoodsClass(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Map<String, Object> buildComGoodsParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract String sendComSaveGoods(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public String saveSendGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String memberCode, String tenantCode) {
        if (null == rsGoodsClassDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsGoodsClassDomain", rsGoodsClassDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendGoodsClass(String goodsClassCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)goodsClassCode)) {
            this.logger.error(this.SYS_CODE + ".delSendGoodsClass.param");
            return null;
        }
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, channelCode, goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            return "\u3010" + goodsClassCode + "-" + channelCode + "-" + tenantCode + "\u3011\u672a\u5bf9\u7167";
        }
        String channelApiCode = "cmc.disGoods.delSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsClassCode", goodsClassCode);
        param.put("categoryId", categoryId);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String memberCode, String tenantCode) {
        if (null == rsGoodsClassDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String goodsClassCode = rsGoodsClassDomain.getGoodsClassCode();
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, channelCode, goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            return "\u3010" + goodsClassCode + "-" + channelCode + "-" + tenantCode + "\u3011\u672a\u5bf9\u7167";
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("categoryId", categoryId);
        param.put("channelApiCode", channelApiCode);
        param.put("rsGoodsClassDomain", rsGoodsClassDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String uploadImage(ImageBean imageBean) {
        if (null == imageBean) {
            return "ERROR";
        }
        String channelApiCode = "cmc.disGoods.uploadImage";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("imageBean", (Object)imageBean);
        param.put("tenantCode", imageBean.getTenantCode());
        return (String)this.sendCall(param, channelApiCode, null, imageBean.getTenantCode());
    }

    @Override
    public String saveSendGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, String memberCode, String tenantCode) {
        if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelCode = this.getChannelCode();
        String goodsClassCode = rsResourceGoodsReDomain.getClasstreeShopcode();
        if (StringUtils.isBlank((String)goodsClassCode)) {
            goodsClassCode = rsResourceGoodsReDomain.getClasstreeCode();
        }
        String categoryId = this.getCategoryId(tenantCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.saveSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("categoryId", categoryId);
        param.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, String memberCode, String tenantCode) {
        if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelCode = this.getChannelCode();
        String goodsClassCode = rsResourceGoodsReDomain.getClasstreeShopcode();
        if (StringUtils.isBlank((String)goodsClassCode)) {
            goodsClassCode = rsResourceGoodsReDomain.getClasstreeCode();
        }
        String categoryId = this.getCategoryId(tenantCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.updateSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("categoryId", categoryId);
        param.put("channelApiCode", channelApiCode);
        param.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendGoods(String goodsEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.delSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendSku(String goodsEocode, String skuEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.delSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("skuEocode", skuEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    protected void saveFileList(DisChannel disChannel, String fileCode, String fchannelCode, String imageCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "fm.file.updateFileOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fileCode", fileCode);
        paramMap.put("fchannelCode", fchannelCode);
        paramMap.put("imageCode", imageCode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveGoods(DisChannel disChannel, String goodsNo, String goodsCode, String goodsEocode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "rs.resourceGoods.updateGoodsEocode";
        if ("1".equals(disChannel.getChannelGoodstype())) {
            apiCode = "rs.resourceGoods.updateGoodsEocodeByno";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsCode", goodsCode);
        paramMap.put("goodsNo", goodsNo);
        paramMap.put("goodsEocode", goodsEocode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveSku(DisChannel disChannel, String skuNo, String skuCode, String skuEocode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "rs.resourceGoods.updateSkuEocode";
        if ("1".equals(disChannel.getChannelGoodstype())) {
            apiCode = "rs.resourceGoods.updateSkuEocodeByno";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuCode", skuCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("skuEocode", skuEocode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected String getFileOcode(DisChannel disChannel, String fileCode, String fchannelCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "fm.file.getFileOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fileCode", fileCode);
        paramMap.put("fchannelCode", fchannelCode);
        paramMap.put("tenantCode", tenantCode);
        String value = this.internalInvoke(apiCode, paramMap);
        return value;
    }

    @Override
    public String updateSendGoodsClassSort(Integer goodsClassOrder, String goodsClassCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsClassCode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.updateSendGoodsClassSort";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("categoryId", categoryId);
        param.put("goodsClassCode", goodsClassCode);
        param.put("goodsClassOrder", goodsClassOrder);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendBatchGoods(List<RsResourceGoodsReDomain> rsResourceGoodsReDomainList, String memberCode, String tenantCode) {
        if (ListUtil.isEmpty(rsResourceGoodsReDomainList) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendBatchGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsResourceGoodsReDomainList", rsResourceGoodsReDomainList);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendSku(RsSkuDomain rsSkuDomain, String memberCode, String tenantCode) {
        if (null == rsSkuDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomain", rsSkuDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSku(RsSkuDomain rsSkuDomain, String memberCode, String tenantCode) {
        if (null == rsSkuDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomain", rsSkuDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendBatchSku(List<RsSkuDomain> rsSkuDomainList, String memberCode, String tenantCode) {
        if (ListUtil.isEmpty(rsSkuDomainList) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendBatchSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomainList", rsSkuDomainList);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuUp(String goodsEocode, String skuEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("skuEocode", skuEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuDow(String goodsEocode, String skuEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("skuEocode", skuEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsUp(String goodsEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsDow(String goodsEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsEocode", goodsEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuPrice(BigDecimal pricesetNprice, String goodsEocode, String skuEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuPrice";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("pricesetNprice", pricesetNprice);
        param.put("goodsEocode", goodsEocode);
        param.put("skuEocode", skuEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuNum(BigDecimal goodsSupplynum, String goodsEocode, String skuEocode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuNum";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsSupplynum", goodsSupplynum);
        param.put("goodsEocode", goodsEocode);
        param.put("skuEocode", skuEocode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }
}

