/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisSignService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.channel.discom.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.discom.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class DisBaseServiceImpl
extends BaseServiceImpl {
    private static final String SYS_CODE = "cmc.DisBaseServiceImpl";
    private String cacheChannelConfig = "DisChannelConfig-channelCode";
    String cacheChannel = "DisChannel-channelCode";
    private String cachetokenkey = "DisOauthToken-channelCode";
    private String cacheDictionarykey = "DisDictionary-channelCode";
    private String cacheDictionaryDiskey = "DisDictionaryDis-channelCode";
    DisSignService disSignService;

    protected abstract String getChannelCode();

    public DisSignService getDisSignService() {
        return this.disSignService;
    }

    public void setDisSignService(DisSignService disSignService) {
        this.disSignService = disSignService;
    }

    protected String getDictionaryDisValue(String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        return this.getDictionaryComValue(this.cacheDictionaryDiskey, tenantCode, channelCode, dictionaryType, propertis, value);
    }

    protected String getShoppingId(String tenantCode, String channelCode, String memberCode) {
        String shoppingId = this.getDictionaryValue(tenantCode, channelCode, "UmUserinfo", "userinfoCode", memberCode);
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getShoppingId.shoppingId", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        return shoppingId;
    }

    protected String getBrandId(String tenantCode, String channelCode, String brandCode) {
        String brandId = this.getDictionaryValue(tenantCode, channelCode, "RsBrand", "brandCode", brandCode);
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getBrandId.brandId", (Object)(channelCode + "-" + brandCode + "-" + tenantCode));
            return null;
        }
        return brandId;
    }

    protected String getClasstreeId(String tenantCode, String channelCode, String classtreeCode) {
        String classtreeId = this.getDictionaryValue(tenantCode, channelCode, "RsClasstree", "classtreeCode", classtreeCode);
        if (StringUtils.isBlank((String)classtreeId)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getClassId.classId", (Object)(channelCode + "-" + classtreeCode + "-" + tenantCode));
            return null;
        }
        return classtreeId;
    }

    protected String getOutMemId(String tenantCode, String channelCode, String memberCode) {
        String member = this.getDictionaryValue(tenantCode, channelCode, "UmUserinfo", "memberCode", memberCode);
        if (StringUtils.isBlank((String)member)) {
            this.logger.error("cmc.DisBaseServiceImpl.getOutMemId.member", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        return member;
    }

    protected String getMemberCode(String tenantCode, String channelCode, String shoppingId) {
        String memberCode = this.getDictionaryDisValue(tenantCode, channelCode, "UmUserinfo", "shopId", shoppingId);
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error("cmc.DisBaseServiceImpl.getMemberCode.memberCode", (Object)(channelCode + "-" + shoppingId + "-" + tenantCode));
            return null;
        }
        return memberCode;
    }

    protected String getOrderState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "DisContract", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getOrderState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected String getRefundFlag(String tenantCode, String channelCode, String refundStatus) {
        String refundFlag = this.getDictionaryDisValue(tenantCode, channelCode, "DisContract", "refundStatus", refundStatus);
        if (StringUtils.isBlank((String)refundFlag)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getRefundFlag.refundFlag", (Object)(channelCode + "-" + refundStatus + "-" + tenantCode));
            return null;
        }
        return refundFlag;
    }

    private String getDictionaryComValue(String cachekey, String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        if (StringUtils.isBlank((String)cachekey) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)propertis) || StringUtils.isBlank((String)value)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getDictionaryComValue.param");
            return null;
        }
        String valueStr = DisUtil.getMap((String)cachekey, (String)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
        if (StringUtils.isBlank((String)valueStr)) {
            this.logger.debug("cmc.DisBaseServiceImpl.getDictionaryComValue.valueStr", (Object)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
            return null;
        }
        String[] values = valueStr.split("\\,");
        if (null == values || values.length < 1) {
            return null;
        }
        return values[1];
    }

    protected String getDictionaryValue(String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        return this.getDictionaryComValue(this.cacheDictionarykey, tenantCode, channelCode, dictionaryType, propertis, value);
    }

    protected String getToken(String tenantCode, String channelCode, String memberCode) {
        String tokenStr;
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error("cmc.DisBaseServiceImpl.getToken.param");
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = "";
        }
        if (StringUtils.isBlank((String)(tokenStr = DisUtil.getRemotMap((String)this.cachetokenkey, (String)(channelCode + "-" + memberCode + "-" + tenantCode))))) {
            this.logger.error("cmc.DisBaseServiceImpl.getToken.tokenStr", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            this.logger.error("cmc.DisBaseServiceImpl.getToken.disOauthToken", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }

    protected Map<String, String> getChannelConfig(String tenantCode, String channelCode, String channelApiCode) {
        Map allconfigMap;
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error("cmc.DisBaseServiceImpl.getChannelConfig.param");
            return null;
        }
        HashMap<String, String> reconfigMap = new HashMap<String, String>();
        Map configMap = DisUtil.getMapMapJson((String)this.cacheChannelConfig, (String)(channelCode + "-" + channelApiCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + tenantCode), String.class, String.class);
        if (MapUtil.isEmpty((Map)configMap)) {
            configMap = DisUtil.getMapMapJson((String)this.cacheChannelConfig, (String)(channelCode + "-" + channelApiCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + "00000000"), String.class, String.class);
        }
        if (MapUtil.isNotEmpty((Map)configMap)) {
            reconfigMap.putAll(configMap);
        }
        if (MapUtil.isEmpty((Map)(allconfigMap = DisUtil.getMapMapJson((String)this.cacheChannelConfig, (String)(channelCode + "-" + "all" + "-" + ChannelConfigScope.PRO.getCode() + "-" + tenantCode), String.class, String.class)))) {
            allconfigMap = DisUtil.getMapMapJson((String)this.cacheChannelConfig, (String)(channelCode + "-" + "all" + "-" + ChannelConfigScope.PRO.getCode() + "-" + "00000000"), String.class, String.class);
        }
        if (MapUtil.isNotEmpty((Map)allconfigMap)) {
            reconfigMap.putAll(allconfigMap);
        }
        if (MapUtil.isEmpty(reconfigMap)) {
            this.logger.error("cmc.DisBaseServiceImpl.getChannelConfig.configMap", (Object)(channelCode + "-" + channelApiCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + tenantCode));
            return null;
        }
        String serviceUrl = (String)reconfigMap.get("serviceUrl");
        if (StringUtils.isNotBlank((String)serviceUrl) && serviceUrl.indexOf("{host}") >= 0) {
            serviceUrl = serviceUrl.replaceAll("\\{host\\}", (String)reconfigMap.get("host"));
            reconfigMap.put("serviceUrl", serviceUrl);
        }
        return reconfigMap;
    }

    protected DisChannel getDisChannel(String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error("cmc.DisBaseServiceImpl.getDisChannel.param");
            return null;
        }
        String json = DisUtil.getMap((String)this.cacheChannel, (String)(channelCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.DisBaseServiceImpl.getDisChannel.json", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        DisChannel disChannel = (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(json, DisChannel.class);
        if (null == disChannel) {
            this.logger.error("cmc.DisBaseServiceImpl.getDisChannel.disChannel", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disChannel;
    }

    protected Map<String, Object> getApiparamAll(Map<String, Object> param, String channelCode, String channelApiCode, String tenantCode) {
        return this.getApiparam(param, channelCode, channelApiCode, tenantCode, true);
    }

    protected Map<String, Object> getApiparam(Map<String, Object> param, String channelCode, String channelApiCode, String tenantCode) {
        return this.getApiparam(param, channelCode, channelApiCode, tenantCode, false);
    }

    private Map<String, Object> getApiparam(Map<String, Object> param, String channelCode, String channelApiCode, String tenantCode, boolean all) {
        Map<String, String> configMap;
        List apiparamList;
        String paramallkey;
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)channelApiCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("cmc.DisBaseServiceImpl.getApiparam.param");
        }
        String paramkey = channelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + tenantCode;
        List apiparamAllList = null;
        if (all && ListUtil.isEmpty((Collection)(apiparamAllList = DisUtil.getMapListJson((String)"DisChannelApiparam-channelCode", (String)(paramallkey = channelCode + "-" + "all" + "-" + ChannelApiParamType.IN.getCode() + "-" + tenantCode), DisChannelApiparam.class)))) {
            paramallkey = channelCode + "-" + "all" + "-" + ChannelApiParamType.IN.getCode() + "-" + "00000000";
            apiparamAllList = DisUtil.getMapListJson((String)"DisChannelApiparam-channelCode", (String)paramallkey, DisChannelApiparam.class);
        }
        if (ListUtil.isEmpty((Collection)(apiparamList = DisUtil.getMapListJson((String)"DisChannelApiparam-channelCode", (String)paramkey, DisChannelApiparam.class)))) {
            paramkey = channelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + "00000000";
            apiparamList = DisUtil.getMapListJson((String)"DisChannelApiparam-channelCode", (String)paramkey, DisChannelApiparam.class);
        }
        if (ListUtil.isEmpty((Collection)apiparamList) && ListUtil.isEmpty(apiparamAllList)) {
            this.logger.error("cmc.DisBaseServiceImpl.getApiparam.apiParamStr", (Object)paramkey);
            return null;
        }
        ArrayList<DisChannelApiparam> reapiparamList = new ArrayList<DisChannelApiparam>();
        if (ListUtil.isNotEmpty((Collection)apiparamList)) {
            reapiparamList.addAll(apiparamList);
            param.put("apiparamList", apiparamList);
        }
        if (ListUtil.isNotEmpty(apiparamAllList)) {
            reapiparamList.addAll(apiparamAllList);
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode))) {
            this.logger.error("cmc.DisBaseServiceImpl.getApiparam.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return null;
        }
        String redirect_uri = configMap.get("redirect_uri");
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isNotBlank((String)memberCode) && StringUtils.isNotBlank((String)redirect_uri) && redirect_uri.indexOf("{memberCode}") >= 0) {
            redirect_uri = redirect_uri.replaceAll("\\{memberCode\\}", memberCode);
            configMap.put("redirect_uri", redirect_uri);
        }
        return this.buildParamMap(param, configMap, reapiparamList);
    }

    private Map<String, Object> buildParamMap(Map<String, Object> param, Map<String, String> configMap, List<DisChannelApiparam> apiparamList) {
        if (null == configMap || configMap.isEmpty() || null == apiparamList || apiparamList.isEmpty()) {
            this.logger.error("cmc.DisBaseServiceImpl.buildParamMap.null");
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> jsMap = new HashMap<String, Map<String, Object>>();
        jsMap.put("config", configMap);
        jsMap.put("param", param);
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            Object value = "";
            String jsstr = disChannelApiparam.getChannelApiparamMcon();
            String mname = disChannelApiparam.getChannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                if (!jsstr.equals("java:makeGild")) {
                    value = jsstr.equals("java:timestamp") ? DateUtils.parseDateTime((Date)new Date()) : (jsstr.equals("java:uuid") ? UUID.randomUUID().toString().replaceAll("-", "") : (jsstr.equals("java:uuid4") ? UUID.randomUUID().toString() : ScriptUtil.evel((String)jsstr, jsMap)));
                }
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            paramMap.put(disChannelApiparam.getChannelApiparamKey(), value);
        }
        return paramMap;
    }

    public Object sendCall(Map<String, Object> param, String channelApiCode, String memberCode, String tenantCode) {
        Map<String, String> configMap;
        String outMember;
        if (StringUtils.isBlank((String)channelApiCode) || StringUtils.isBlank((String)tenantCode)) {
            return "ERROR";
        }
        String channelCode = this.getChannelCode();
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error("cmc.DisBaseServiceImpl.sendCall.disChannel", (Object)(tenantCode + "-" + channelCode));
            return tenantCode + "-" + channelCode + " \u6e20\u9053\u4e3a\u7a7a";
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            String shoppingId = this.getShoppingId(tenantCode, channelCode, memberCode);
            if (StringUtils.isBlank((String)shoppingId)) {
                this.logger.error("cmc.DisBaseServiceImpl.sendCall.shoppingId", (Object)(channelCode + "-" + "-" + memberCode + "-" + tenantCode));
            }
            param.put("shoppingId", shoppingId);
        }
        if (StringUtils.isNotBlank((String)(outMember = this.getOutMemId(tenantCode, channelCode, disChannel.getMemberCode())))) {
            param.put("outMember", outMember);
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode))) {
            this.logger.error("cmc.DisBaseServiceImpl.sendCall.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return tenantCode + "-" + channelCode + "-" + channelApiCode + " \u672a\u914d\u7f6e\u6e20\u9053\u4fe1\u606f";
        }
        param.put("channelApiCode", channelApiCode);
        param.put("channelCode", channelCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        Map<String, Object> sendParam = this.getApiparamAll(param, channelCode, channelApiCode, tenantCode);
        if (MapUtil.isEmpty(sendParam)) {
            this.logger.error("cmc.DisBaseServiceImpl.sendCall.sendParam", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode + ":" + configMap.toString()));
            return tenantCode + "-" + channelCode + "-" + channelApiCode + " \u53c2\u6570\u89e3\u6790\u5f02\u5e38";
        }
        Map<String, Object> sendhttpParam = this.buildComParam(channelApiCode, disChannel, sendParam, configMap, param);
        String msg = this.getDisSignService().sign(sendhttpParam, configMap);
        if (!"SUCCESS".equals(msg)) {
            return msg;
        }
        return this.sendComParam(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    public abstract Map<String, Object> buildComParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);
}

