/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisOrderService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisOrderBaseService
extends DisBaseServiceImpl
implements DisOrderService {
    private String SYS_CODE = "cmc.DisOrderBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return this.buildComOrderParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    public abstract Map<String, Object> buildComOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComOrder(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        return this.sendComOrder(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    @Override
    public QueryResult<DisContractDomain> queryOrder(String memberCode, String tenantCode, String param, int pageNo, int pageSize) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.queryOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("pageNo", pageNo);
        paramMap.put("pageSize", pageSize);
        paramMap.put("param", param);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (QueryResult)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public QueryResult<DisContractDomain> queryTimeOrder(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        String channelApiCode = "cmc.disOrder.queryTimeOrder";
        map.put("channelApiCode", channelApiCode);
        return (QueryResult)this.sendCall(map, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisContractDomain getSendOrder(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisContractDomain)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendOrderState(Map<String, Object> map) {
        String channelApiCode;
        Map<String, String> configMap;
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.map");
            return null;
        }
        String channelCode = (String)map.get("channelCode");
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode = "cmc.disOrder.saveSendOrderState"))) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        if (!this.getDisSignService().verifySign(map, configMap)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.verifySign", (Object)(map.toString() + "=" + configMap.toString()));
            return "\u9a8c\u7b7e\u5931\u8d25";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.putAll(map);
        Map<String, Object> sendparam = this.buildOrderParam(paramMap);
        if (MapUtil.isEmpty(sendparam)) {
            return null;
        }
        return this.saveOrderParam(channelApiCode, disChannel, sendparam, configMap, paramMap);
    }

    public abstract Map<String, Object> buildOrderParam(Map<String, Object> var1);

    public abstract String saveOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    protected void saveOrder(List<DisContractDomain> disContractDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disContractDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.saveContractBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disContractDomainList", JsonUtil.buildNormalBinder().toJson(disContractDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisContractDomain getContractByNbCode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected void updateOrder(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> map, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateContractStateByNbCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("dataState", dataState);
        paramMap.put("channelCode", disChannel.getChannelCode());
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected GoodsBean getResourceBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (GoodsBean)this.getForObject(apiCode, GoodsBean.class, paramMap);
    }
}

