/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisOrderService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgOccontractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDataDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisOrderBaseService
extends DisBaseServiceImpl
implements DisOrderService {
    private String SYS_CODE = "cmc.DisOrderBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return this.buildComOrderParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    public abstract Map<String, Object> buildComOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComOrder(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        return this.sendComOrder(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    @Override
    public QueryResult<DisContractDomain> queryOrder(String memberCode, String tenantCode, String param, int pageNo, int pageSize) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.queryOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("pageNo", pageNo);
        paramMap.put("pageSize", pageSize);
        paramMap.put("param", param);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (QueryResult)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public QueryResult<DisContractDomain> queryTimeOrder(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        String channelApiCode = "cmc.disOrder.queryTimeOrder";
        map.put("channelApiCode", channelApiCode);
        return (QueryResult)this.sendCall(map, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisContractDomain getSendOrder(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        Object obj = this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
        if (null == obj) {
            return null;
        }
        if (obj instanceof DisContractDomain) {
            return (DisContractDomain)obj;
        }
        this.logger.error(this.SYS_CODE + ".getSendOrder.return", obj);
        return null;
    }

    @Override
    public String saveSendOrderState(Map<String, Object> map) {
        String channelApiCode;
        Map<String, String> configMap;
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.map");
            return null;
        }
        String channelCode = (String)map.get("channelCode");
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode = "cmc.disOrder.saveSendOrderState"))) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        if (!this.getDisSignService().verifySign(map, configMap)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.verifySign", (Object)(map.toString() + "=" + configMap.toString()));
            return "\u9a8c\u7b7e\u5931\u8d25";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.putAll(map);
        Map<String, Object> sendparam = this.buildOrderParam(paramMap);
        if (MapUtil.isEmpty(sendparam)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.sendparam: ", paramMap);
            return null;
        }
        return this.saveOrderParam(channelApiCode, disChannel, sendparam, configMap, paramMap);
    }

    public abstract Map<String, Object> buildOrderParam(Map<String, Object> var1);

    public abstract String saveOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    protected void saveOrder(List<DisContractDomain> disContractDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disContractDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.saveContractBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disContractDomainList", JsonUtil.buildNormalBinder().toJson(disContractDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisContractDomain getContractByNbCode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected DisContractDomain getContractDomainByCode(String tenantCode, String contractBillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected void updateOrder(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> map, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateContractStateByNbCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("dataState", dataState);
        paramMap.put("channelCode", disChannel.getChannelCode());
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateExtrinsicStateByRefundCode(String refundCode, String dataOpnextbillstate, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)dataOpnextbillstate) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "oc.refund.updateExtrinsicStateByRefundCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("dataOpnextbillstate", dataOpnextbillstate);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected GoodsBean getResourceBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (GoodsBean)this.getForObject(apiCode, GoodsBean.class, paramMap);
    }

    protected SgOccontractReDomain getOccontractByNbbillCode(String tenantCode, String channelCode, String contractNbbillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractNbbillcode)) {
            this.logger.error(this.SYS_CODE + ".getOccontractByNbbillCode.", (Object)(channelCode + " =:= " + channelCode + " =:= " + contractNbbillcode));
            return null;
        }
        String apiCode = "sg.sgOccontract.getOccontractByNbbillCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", contractNbbillcode);
        paramMap.put("channelCode", channelCode);
        return (SgOccontractReDomain)this.getForObject(apiCode, SgOccontractReDomain.class, paramMap);
    }

    protected void saveRefund(List<DisRefundDomain> disRefundDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disRefundDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendSaveRefundBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomainList", JsonUtil.buildNormalBinder().toJson(disRefundDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void sendUpdateRefundStateByCode(String tenantCode, String refundCode, String channelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (null == tenantCode || null == refundCode || null == channelCode || null == dataState || null == oldDataState) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateRefundStateByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundCode", refundCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", map);
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisRefundDomain getRefundByOCode(String tenantCode, String refundOcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)refundOcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundDomain)this.getForObject(apiCode, DisRefundDomain.class, paramMap);
    }

    protected DisRefundReDomain getRefundByNbillcode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundReDomain)this.getForObject(apiCode, DisRefundReDomain.class, paramMap);
    }

    protected SgSendgoodsLogDomain getSgsendgoodsLogBysgCode(String tenantCode, String sendgoodsCode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendgoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoodsLog.querySendgoodsLogBySendCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendgoodsCode);
        return (SgSendgoodsLogDomain)this.getForObject(apiCode, SgSendgoodsLogDomain.class, paramMap);
    }

    @Override
    public String updateSendOrderCanRefund(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderCanRefund";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String viewStatus(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.viewStatus";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String privateinfo(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.privateinfo";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String queryComment(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.queryComment";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String commentReply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.commentReply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPlatDelivery(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPlatDelivery";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    protected SgSendgoodsReDomain getSgSendGoodsByCode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSgSendGoods(String tenantCode, String channelCode, String contractBillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSgSendGoods";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        map.put("contractBillcode", contractBillcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSendgoodsReDomainByNbbillcode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByNbbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected String getSgSendgoodsState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "SgSendgoods", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getSgSendgoodsState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected String getOcContractState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "ocContract", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getOcContractState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected void sendSaveSgSendGoodsState(List<SgSendgoodsDataDomain> sgSendgoodsDataDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsDataDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendSaveSgSendGoodsState ", sgSendgoodsDataDomainList);
            return;
        }
        String apiCode = "sg.sendgoods.sendSgSendgoodsDataBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDataDomainList", JsonUtil.buildNormalBinder().toJson(sgSendgoodsDataDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public String updateSendOrderDelivery(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderDelivery";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderReceiveAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderReceiveAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderOK(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderOK";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPrint(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPrint";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserNoAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserNoAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getSendOrderLog(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendOrderLog";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserCanelAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserCanelAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAddTips(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAddTips";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPickCode(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPickCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String remindReply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.remindReply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String untreatedRemind(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.untreatedRemind";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String untreatedCancelList(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.untreatedCancelList";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String convertOrderNum(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.convertOrderNum";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderDaySeq(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderDaySeq";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String partrefundApply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.partrefundApply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderActDetail(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderActDetail";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderIdByDaySeq(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderIdByDaySeq";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderIdByDaySeqSection(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderIdByDaySeqSection";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getHandleReportRecord(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getHandleReportRecord";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAdjust(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getPartRefundDetail(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String partRefundFoodsDetail(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderDeling(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderDeling";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }
}

