/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisRefundBaseService
extends DisBaseServiceImpl
implements DisRefundService {
    private String SYS_CODE = "cmc.DisRefundBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return this.buildComRefundParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    public abstract Map<String, Object> buildComRefundParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComRefund(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        return this.sendComRefund(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    @Override
    public QueryResult<DisRefundDomain> queryRefund(String memberCode, String tenantCode, String param, int pageNo, int pageSize) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.queryRefund";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("pageNo", pageNo);
        paramMap.put("pageSize", pageSize);
        paramMap.put("param", param);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (QueryResult)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public QueryResult<DisRefundDomain> queryTimeRefund(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        String channelApiCode = "cmc.disRefund.queryTimeRefund";
        map.put("channelApiCode", channelApiCode);
        return (QueryResult)this.sendCall(map, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisRefundDomain getSendRefund(String contractNbillcode, String refundOcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.getSendRefund";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisRefundDomain)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    public List<Map<String, Object>> getRefundByOrderId(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.getRefundByOrderId";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (List)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendRefundState(Map<String, Object> map) {
        String channelApiCode;
        Map<String, String> configMap;
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".saveSendRefundState.map");
            return null;
        }
        String channelCode = (String)map.get("channelCode");
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode = "cmc.disRefund.saveSendRefundState"))) {
            this.logger.error(this.SYS_CODE + ".saveSendRefundState.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        if (!this.getDisSignService().verifySign(map, configMap)) {
            this.logger.error(this.SYS_CODE + ".saveSendRefundState.verifySign", (Object)(map.toString() + "=" + configMap.toString()));
            return "\u9a8c\u7b7e\u5931\u8d25";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.putAll(map);
        Map<String, Object> sendparam = this.buildRefundParam(paramMap);
        if (MapUtil.isEmpty(sendparam)) {
            return null;
        }
        return this.saveRefundParam(channelApiCode, disChannel, sendparam, configMap, paramMap);
    }

    public abstract Map<String, Object> buildRefundParam(Map<String, Object> var1);

    public abstract String saveRefundParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    protected void saveRefund(List<DisRefundDomain> disRefundDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disRefundDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendSaveRefundBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomainList", JsonUtil.buildNormalBinder().toJson(disRefundDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisContractDomain getContractByNbCode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected DisContractDomain getContractDomainByCode(String tenantCode, String contractBillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected DisRefundDomain getRefundByOCode(String tenantCode, String refundOcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)refundOcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundDomain)this.getForObject(apiCode, DisRefundDomain.class, paramMap);
    }

    protected void updateRefund(String tenantCode, String refundOcode, Integer dataState, Integer oldDataState, Map<String, Object> map, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)refundOcode)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateRefundStateByOcode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("dataState", dataState);
        paramMap.put("channelCode", disChannel.getChannelCode());
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected GoodsBean getResourceBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (GoodsBean)this.getForObject(apiCode, GoodsBean.class, paramMap);
    }

    @Override
    public String saveSendRefund(DisRefundDomain disRefundDomain, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.saveSendRefund";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("disRefundDomain", disRefundDomain);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisRefundDomain saveSendRefundAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.saveSendRefundAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisRefundDomain)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendRefundCannel(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.updateSendRefundCannel";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendRefundOk(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disRefund.updateSendRefundOk";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }
}

