/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.ext.channel.discom.api.DisStoreService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUser;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class DisStoreBaseService
extends DisBaseServiceImpl
implements DisStoreService {
    private String SYS_CODE = "cmc.DisStoreBaseService";

    @Override
    public UmUserinfo getStore(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disStore.getStore";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (UmUserinfo)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendStoreStart(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return "ERROR";
        }
        String channelApiCode = "cmc.disStore.updateSendStoreStart";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendStoreEnd(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return "ERROR";
        }
        String channelApiCode = "cmc.disStore.updateSendStoreEnd";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String commentScore(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return "ERROR";
        }
        String channelApiCode = "cmc.disStore.commentScore";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String limitedTaking(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disStore.limitedTaking";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendStore(UmUserinfo umUserinfo, UmUser umUser) {
        if (null == umUserinfo) {
            return "ERROR";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String memberCode = umUserinfo.getUserinfoCode();
        String channelApiCode = "cmc.disStore.updateSendStore";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("umUserinfo", umUserinfo);
        param.put("umUser", umUser);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendStore(UmUserinfo umUserinfo, UmUser umUser) {
        if (null == umUserinfo) {
            return "ERROR";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String memberCode = umUserinfo.getUserinfoCode();
        String channelApiCode = "cmc.disStore.saveSendStore";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("umUserinfo", umUserinfo);
        param.put("umUser", umUser);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStore") || channelApiCode.equals("cmc.disStore.saveSendStore")) {
            return this.buildStoreUpdateParam(disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStoreEnd")) {
            return this.buildStoreEndParam(disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStoreStart")) {
            return this.buildStoreStartParam(disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.getStore")) {
            return this.buildGetStoreParam(disChannel, sendParam, configMap, param);
        }
        return null;
    }

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStore") || channelApiCode.equals("cmc.disStore.saveSendStore")) {
            return this.sendStoreUpdateParam(disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStoreEnd")) {
            return this.sendStoreEndParam(disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.updateSendStoreStart")) {
            return this.sendStoreStartParam(disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disStore.getStore")) {
            return this.sendGetStore(disChannel, sendhttpParam, configMap, param);
        }
        return null;
    }

    public abstract Map<String, Object> buildStoreUpdateParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract Map<String, Object> buildStoreStartParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract Map<String, Object> buildStoreEndParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract Map<String, Object> buildGetStoreParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract String sendStoreUpdateParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract String sendStoreStartParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract UmUserinfo sendGetStore(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    public abstract String sendStoreEndParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);
}

