/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.dm.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.dm.YbConstants;
import com.yqbsoft.laser.service.ext.channel.dm.service.ChannelQueryServiceImpl;
import com.yqbsoft.laser.service.ext.channel.dm.util.DateUtils;
import com.yqbsoft.laser.service.ext.channel.dm.util.DmUtil;
import com.yqbsoft.laser.service.ext.channel.dm.util.HttpClentUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    public String getFchannelCode() {
        return YbConstants.channelCode;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        this.logger.error("cmc.ChannelInBaseService.httpInvoke.dm", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelInBaseService.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelInBaseService.sign.null", "");
        }
        Map requestData = channelRequest.getRequestData();
        String contractBillcode = channelRequest.getCmChannelClear().getBusinessOrderno();
        String channelClearSeqno = channelRequest.getCmChannelClear().getChannelClearSeqno();
        String tenantCode = channelRequest.getCmChannelClear().getTenantCode();
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("cmc.ChannelInBaseService.httpInvoke.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelInBaseService.httpInvoke.channelRequest");
        }
        HashMap<String, String> mapStr1 = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        mapStr1.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        OcContractReDomain ocContractReDomain = (OcContractReDomain)this.getForObject("oc.contract.getContractByCode", OcContractReDomain.class, mapStr1);
        if (ocContractReDomain == null) {
            this.logger.info("cmc.ChannelInBaseService.httpInvoke.ocContractReDomain", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return null;
        }
        String url = channelRequest.getCmFchannelApi().getFchannelApiUrl();
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        mapStr.put("requestId", this.createUUIDString());
        mapStr.put("partnerMemberId", ocContractReDomain.getMemberBcode());
        mapStr.put("partnerName", ocContractReDomain.getMemberBname());
        if (StringUtils.isNotBlank((String)ocContractReDomain.getGoodsReceiptPhone())) {
            mapStr.put("phone", ocContractReDomain.getGoodsReceiptPhone());
        } else {
            mapStr.put("phone", "15715601115");
        }
        mapStr.put("tenantCode", tenantCode);
        String token = ChannelQueryServiceImpl.getToken(mapStr, url);
        if (StringUtils.isBlank((String)token)) {
            this.logger.info("cmc.ChannelInBaseService.httpInvoke.token", (Object)(JsonUtil.buildNormalBinder().toJson(mapStr) + "url" + url));
            return null;
        }
        this.logger.error("cmc.ChannelInBaseService.token", (Object)(JsonUtil.buildNormalBinder().toJson((Object)token) + "mapStr" + mapStr + "url" + url));
        map1.put("partnerMemberId", ocContractReDomain.getMemberBcode());
        map1.put("bizOrderNo", channelRequest.getCmChannelClear().getChannelClearSeqno());
        map1.put("inPartnerMemberId", ocContractReDomain.getMemberCode());
        map1.put("orderAmount", requestData.get("orderAmount"));
        map1.put("token", token);
        String orderCode = this.getOrder(url, map1);
        if (StringUtils.isBlank((String)orderCode)) {
            this.logger.info("cmc.ChannelInBaseService.httpInvoke.order", (Object)(JsonUtil.buildNormalBinder().toJson(map1) + "url" + url));
            return null;
        }
        String payUrl = DmUtil.getUrl(tenantCode, "dmPayUrl", "url");
        if (StringUtils.isBlank((String)payUrl)) {
            this.logger.info("cmc.ChannelInBaseService.httpInvoke.payUrl", (Object)(JsonUtil.buildNormalBinder().toJson(map1) + "payUrl" + payUrl));
            return null;
        }
        HashMap<String, String> mapstr = new HashMap<String, String>();
        mapstr.put("payUrl", payUrl);
        mapstr.put("orderCode", orderCode);
        mapstr.put("token", token);
        payUrl = JsonUtil.buildNonNullBinder().toJson(mapstr);
        this.logger.error("cmc.ChannelInBaseService.payUrl!!!!!!!", (Object)("payUrl" + payUrl));
        return payUrl;
    }

    public String getOrder(String url, Map<String, Object> map1) {
        Map data;
        Map jsonToMap;
        BigDecimal orderAmount = new BigDecimal(map1.get("orderAmount").toString());
        url = url + "/dmfreshpay/dmapi/payment/topay";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", this.createUUIDString());
        map.put("requestTime", DateUtils.getNewTime());
        map.put("partnerMemberId", map1.get("partnerMemberId").toString());
        map.put("bizOrderNo", map1.get("bizOrderNo").toString());
        map.put("inPartnerMemberId", map1.get("inPartnerMemberId").toString());
        map.put("orderAmount", orderAmount.multiply(new BigDecimal("100")));
        map.put("goodsInfo", "\u65e0");
        map.put("token", map1.get("token").toString());
        String jsonStr = JsonUtil.buildNonEmptyBinder().toJson(map);
        String result = HttpClentUtil.httpPostByJson(url, jsonStr);
        String orderCode = null;
        this.logger.error("cmc.ChannelInBaseService.getOrder", (Object)("map1" + map1 + "url" + url + "jsonStr" + jsonStr));
        if (StringUtils.isNotBlank((String)result) && MapUtil.isNotEmpty((Map)(jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class))) && jsonToMap.get("code").toString().equals("200") && MapUtil.isNotEmpty((Map)(data = (Map)jsonToMap.get("data")))) {
            orderCode = (String)data.get("orderCode");
        }
        return orderCode;
    }

    public static void main(String[] args) {
    }
}

