/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.elm.service;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisSignService;
import com.yqbsoft.laser.service.ext.channel.elm.ElmConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

public class DisSignServiceImpl
extends BaseServiceImpl
implements DisSignService {
    protected String SYS_CODE = "elm.DisSignServiceImpl";

    protected String getChannelCode() {
        return ElmConstants.channelCode;
    }

    public String generateSignature(String appKey, String secret, long timestamp, String action, String token, Map<String, Object> parameters) {
        if (MapUtil.isEmpty(parameters)) {
            return null;
        }
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            sorted.put(entry.getKey(), entry.getValue());
        }
        sorted.put("app_key", appKey);
        sorted.put("timestamp", timestamp);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : sorted.entrySet()) {
            string.append((String)entry.getKey()).append("=").append(JsonUtil.buildNormalBinder().toJson(entry.getValue()));
        }
        String splice = String.format("%s%s%s%s", action, token, string, secret);
        String calculatedSignature = this.md5(splice);
        return calculatedSignature.toUpperCase();
    }

    public String md5(String str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] byteData = md.digest();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < byteData.length; ++i) {
            buffer.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return buffer.toString();
    }

    public String sign(Map<String, Object> paramMap, Map<String, String> configMap) {
        Map parameters;
        String token;
        String action;
        String secret;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(configMap)) {
            return "ERROR";
        }
        Map metasMap = (Map)paramMap.get("metas");
        if (MapUtil.isEmpty((Map)metasMap)) {
            return "ERROR";
        }
        long timestamp = (Long)metasMap.get("timestamp");
        String appKey = configMap.get("key");
        String sign = this.generateSignature(appKey, secret = configMap.get("secret"), timestamp, action = (String)paramMap.get("action"), token = (String)paramMap.get("token"), parameters = (Map)paramMap.get("params"));
        if (StringUtils.isBlank((String)sign)) {
            return "ERROR";
        }
        paramMap.put("signature", sign);
        return "SUCCESS";
    }

    public boolean verifySign(Map<String, Object> paramMap, Map<String, String> configMap) {
        return true;
    }
}

