/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.rpa.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.rpa.model.OcContractGoodsDomain;
import com.yqbsoft.laser.service.rpa.model.OcContractReDomain;
import com.yqbsoft.laser.service.rpa.service.RpaOrderService;
import com.yqbsoft.laser.service.rpa.util.FTPUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RpaOrderServiceImpl
extends BaseServiceImpl
implements RpaOrderService {
    protected String SYS_CODE = "hdbrpa.RpaOrderServiceImpl";

    @Override
    public void exportOrderToHDBXs() {
        this.logger.error(this.SYS_CODE + ".exportOrderToHDBXs", (Object)"\u8fdb\u5165\u5bfc\u51fa\u7ebf\u4e0a\u5546\u57ce\u8ba2\u5355\uff01\uff01\uff01");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", "2020063000000001");
        paramMap.put("contractPmode", "0,2");
        paramMap.put("dataStateStr", "3");
        paramMap.put("childFlag", "1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.exportData(map);
    }

    @Override
    public void exportOrderToHDBXx() {
        this.logger.error(this.SYS_CODE + ".exportOrderToHDBXx", (Object)"\u8fdb\u5165\u5bfc\u51fa\u7ebf\u4e0b\u5546\u57ce\u8ba2\u5355\uff01\uff01\uff01");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", "2020063000000001");
        paramMap.put("contractPmode", "1");
        paramMap.put("dataStateStr", "3");
        paramMap.put("childFlag", "1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.exportData(map);
    }

    @Override
    public String synchronousOrder(String orderJsonStr) {
        if (StringUtils.isBlank((String)orderJsonStr)) {
            throw new ApiException(this.SYS_CODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray jsonArray = JSONArray.json2array((String)orderJsonStr);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("tenantCode", "2020063000000001");
        for (JSONObject jsonObject : jsonArray) {
            String contractBillcode = jsonObject.getString("contractBillcode");
            String contractNbillcode = jsonObject.getString("contractNbillcode");
            if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractNbillcode)) {
                throw new ApiException(this.SYS_CODE, "\u5546\u57ce\u8ba2\u5355\u53f7/\u5916\u90e8\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff01");
            }
            tempMap.put("contractBillcode", contractBillcode);
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(tempMap));
            String orderStr = this.internalInvoke("oc.contract.getContractModelByCodes", paramMap);
            if (!StringUtils.isBlank((String)orderStr)) continue;
            throw new ApiException(this.SYS_CODE, "\u5546\u57ce\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        paramMap.clear();
        paramMap.put("tenantCode", "2020063000000001");
        for (JSONObject jsonObject : jsonArray) {
            paramMap.put("contractBillcode", jsonObject.getString("contractBillcode"));
            paramMap.put("contractNbillcode", jsonObject.getString("contractNbillcode"));
            try {
                this.internalInvoke("oc.contract.updateContractContractNbillcode", paramMap);
            }
            catch (Exception e) {
                throw new ApiException(this.SYS_CODE, "\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u5931\u8d25\uff01");
            }
        }
        return "success";
    }

    private void exportData(Map<String, Object> paramMap) {
        this.logger.error(this.SYS_CODE + ".exportData.\u53c2\u6570", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
        String json = this.internalInvoke("oc.contract.queryContractPageReDomain", paramMap);
        this.logger.error(this.SYS_CODE + ".exportData.\u8ba2\u5355\u6570\u636e", (Object)json);
        QueryResult contractReDomainQueryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractReDomainQueryResult.getList()), OcContractReDomain.class);
        if (ListUtil.isNotEmpty((Collection)list)) {
            String exportData = this.assContractMap(list);
            String dataStr = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmmss");
            String tempPath = "Emall-Order_" + dataStr + ".csv";
            String paramStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2020063000000001-hdb_rpa-hdb_rpa");
            try {
                byte[] data = exportData.getBytes(StandardCharsets.UTF_8);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
                FTPUtils ftpUtils = FTPUtils.getInstance(paramStr);
                ftpUtils.storeFile(tempPath, inputStream);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".exportData.\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            }
            for (OcContractReDomain ocContractReDomain : list) {
                if (ocContractReDomain.getDataState() == -1) continue;
                paramMap.clear();
                ocContractReDomain.setDataStatestr("4");
                paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
                this.internalInvoke("oc.contract.updateContract", paramMap);
            }
        }
    }

    private String assContractMap(List<OcContractReDomain> list) {
        StringBuffer sb = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        sb.append("\u533a\u57df\uff08\u6e20\u9053\u540d\u79f0\uff09,\u6e20\u9053\u7f16\u53f7,\u8ba2\u5355\u65e5\u671f,\u5ba2\u6237\u540d\u79f0,\u4f01\u4e1a\u7f16\u53f7\uff08\u5ba2\u6237\uff09,\u8ba2\u5355\u7c7b\u578b,\u5408\u540c\u7f16\u53f7\uff08\u975e\u5fc5\u586b\uff09,\u7269\u6599\u7f16\u7801,\u7269\u6599\u540d\u79f0,\u6570\u91cf,\u9500\u552e\u5355\u4ef7\uff08\u8ba2\u5355\u539f\u4ef7\uff09,\u4fc3\u9500/\u6743\u76ca\u5355\u4ef7,\u4f18\u60e0\u7c7b\u578b,\u5feb\u9012\u8d39,\u5408\u8ba1\u91d1\u989d\uff08\u8ba2\u5355\u4ea4\u6613\u91d1\u989d\uff09,\u652f\u4ed8\u65b9\u5f0f,\u5b9e\u4ed8\u91d1\u989d,\u9500\u552e\u5458\u59d3\u540d,\u9500\u552e\u5458\u7535\u8bdd\r\n");
        for (OcContractReDomain ocContractReDomain : list) {
            if (ocContractReDomain.getDataState() == -1) continue;
            temp.append(ocContractReDomain.getChannelName()).append(",");
            temp.append(ocContractReDomain.getChannelCode()).append(",");
            temp.append(DateUtil.getDateString((Date)ocContractReDomain.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss")).append(",");
            temp.append(ocContractReDomain.getMemberBname()).append(",");
            temp.append(ocContractReDomain.getGoodsList().get(0).getGoodsSpec4()).append(",");
            if ("1".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u96f6\u914d\u4ef6").append(",");
            } else if ("2".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u8017\u6750").append(",");
            } else if ("3".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u7eaa\u5ff5\u54c1").append(",");
            } else {
                temp.append(",");
            }
            temp.append(ocContractReDomain.getContractBillcode()).append(",");
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                sb.append(temp);
                sb.append(ocContractGoodsDomain.getGoodsNo()).append(",");
                sb.append(ocContractGoodsDomain.getGoodsName()).append(",");
                sb.append(ocContractGoodsDomain.getGoodsNum()).append(",");
                sb.append(ocContractGoodsDomain.getContractGoodsMoney()).append(",");
                sb.append(ocContractGoodsDomain.getContractGoodsPrice()).append(",");
                if ("26".equals(ocContractReDomain.getContractType())) {
                    sb.append("\u4fc3\u9500").append(",");
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsSpec5())) {
                    sb.append("\u6743\u76ca").append(",");
                } else {
                    sb.append(",");
                }
                sb.append(ocContractReDomain.getGoodsLogmoney()).append(",");
                sb.append(ocContractReDomain.getDataBmoney()).append(",");
                if ("0".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u7ebf\u4e0a").append(",");
                } else if ("1".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u7ebf\u4e0b").append(",");
                } else if ("2".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u9884\u4ed8\u6b3e").append(",");
                } else {
                    sb.append(",");
                }
                sb.append(ocContractReDomain.getContractInmoney()).append(",");
                sb.append(ocContractReDomain.getUserName()).append(",");
                sb.append(ocContractReDomain.getUserCode()).append(",");
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }
}

