/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.rpa.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;

public class CSVUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportCsv(File file, List<String> dataList) {
        boolean isSuccess = false;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            osw.write(new String(new byte[]{-17, -69, -65}));
            bw = new BufferedWriter(osw);
            if (dataList != null && !dataList.isEmpty()) {
                for (String data : dataList) {
                    bw.append(data).append("\n\r");
                }
            }
            isSuccess = true;
        }
        catch (Exception e) {
            isSuccess = false;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                    bw = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                    osw = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean smbPut(String remoteUrl, String localFilePath) {
        InputStream in = null;
        OutputStream out = null;
        try {
            File localFile = new File(localFilePath);
            String fileName = localFile.getName();
            SmbFile remoteFile = new SmbFile(remoteUrl + "/" + fileName);
            in = new BufferedInputStream(new FileInputStream(localFile));
            out = new BufferedOutputStream((OutputStream)new SmbFileOutputStream(remoteFile));
            byte[] buffer = new byte[1024];
            while (in.read(buffer) != -1) {
                out.write(buffer);
                buffer = new byte[1024];
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> String exportCsv(String fileName, String[] titles, String[] propertys, List<T> list) throws IOException, IllegalArgumentException, IllegalAccessException {
        File file = new File(fileName);
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        for (String title : titles) {
            ow.write(title);
            ow.write(",");
        }
        ow.write("\r\n");
        for (T obj : list) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (String property : propertys) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    if (!property.equals(field.getName())) continue;
                    ow.write(field.get(obj).toString());
                    ow.write(",");
                }
            }
            ow.write("\r\n");
        }
        ow.flush();
        ow.close();
        return "0";
    }
}

