/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.rpa.util;

import com.yqbsoft.laser.service.rpa.model.Ftp;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPUtils {
    private static FTPUtils ftpUtils;
    private FTPClient ftpClient;
    private String port;
    private String username;
    private String password;
    private String ipAddr;
    private String path;
    private InputStream is;

    private FTPUtils() {
        this.initConfig();
        if (null == this.ftpClient) {
            this.ftpClient = new FTPClient();
        }
    }

    private FTPUtils(Ftp ftp) {
        this.port = ftp.getPort();
        this.username = ftp.getUserName();
        this.password = ftp.getPwd();
        this.ipAddr = ftp.getIpAddr();
        this.path = ftp.getPath();
        if (null == this.ftpClient) {
            this.ftpClient = new FTPClient();
        }
    }

    public static synchronized FTPUtils getInstance(String json) {
        Ftp ftp = (Ftp)JsonUtil.buildNormalBinder().getJsonToObject(json, Ftp.class);
        if (null == ftpUtils) {
            ftpUtils = new FTPUtils(ftp);
        }
        return ftpUtils;
    }

    public void initConfig() {
        this.port = "21";
        this.username = "ecftpuser";
        this.password = "heidelberg@ec21";
    }

    public boolean connectToTheServer(String serverName, String remotePath) {
        boolean result = false;
        try {
            this.ftpClient.connect(serverName, Integer.parseInt(this.port));
            this.ftpClient.login(this.username, this.password);
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                this.ftpClient.disconnect();
                return result;
            }
            result = this.ftpClient.changeWorkingDirectory(remotePath);
            result = this.ftpClient.setFileType(2);
            this.ftpClient.setBufferSize(3072);
            this.ftpClient.setControlEncoding("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeFile(String fileName, InputStream is) {
        boolean result = false;
        try {
            result = this.connectToTheServer(this.ipAddr, this.path);
            if (result) {
                result = this.ftpClient.storeFile(fileName, is);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ftpUtils.logout();
        }
        return result;
    }

    public InputStream retrieveFile(String remotePath, String fileName) {
        try {
            boolean result = false;
            result = this.connectToTheServer(this.ipAddr, remotePath);
            if (result) {
                this.is = this.ftpClient.retrieveFileStream(fileName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String remotePath, String fileName) {
        boolean result = false;
        result = this.connectToTheServer(this.ipAddr, remotePath);
        if (result) {
            try {
                result = this.ftpClient.deleteFile(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                ftpUtils.logout();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFile(String remotePath, String fileName) {
        boolean result = false;
        try {
            result = this.connectToTheServer(this.ipAddr, remotePath);
            if (result) {
                String[] remoteNames;
                result = false;
                for (String remoteName : remoteNames = this.ftpClient.listNames()) {
                    if (!fileName.equals(remoteName)) continue;
                    result = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ftpUtils.logout();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout() {
        boolean result = false;
        if (null != this.is) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != this.ftpClient) {
            try {
                result = this.ftpClient.logout();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.ftpClient.isConnected()) {
                    try {
                        this.ftpClient.disconnect();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }
}

